/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt.transport;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltInventory;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelTileEntity;
import com.simibubi.create.content.logistics.block.belts.tunnel.BrassTunnelBlock;
import com.simibubi.create.content.logistics.block.belts.tunnel.BrassTunnelTileEntity;
import com.simibubi.create.content.logistics.block.display.DisplayLinkBlock;
import com.simibubi.create.content.logistics.block.display.DisplayLinkTileEntity;
import com.simibubi.create.content.logistics.block.display.source.AccumulatedItemCountDisplaySource;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;

public class BeltTunnelInteractionHandler {
    public static boolean flapTunnelsAndCheckIfStuck(BeltInventory beltInventory, TransportedItemStack current, float nextOffset) {
        int currentSegment = (int)current.beltPosition;
        int upcomingSegment = (int)nextOffset;
        Direction movementFacing = beltInventory.belt.getMovementFacing();
        if (!beltInventory.beltMovementPositive && nextOffset == 0.0f) {
            upcomingSegment = -1;
        }
        if (currentSegment == upcomingSegment) {
            return false;
        }
        if (BeltTunnelInteractionHandler.stuckAtTunnel(beltInventory, upcomingSegment, current.stack, movementFacing)) {
            current.beltPosition = (float)currentSegment + (beltInventory.beltMovementPositive ? 0.99f : 0.01f);
            return true;
        }
        Level world = beltInventory.belt.m_58904_();
        boolean onServer = !world.f_46443_ || beltInventory.belt.isVirtual();
        boolean removed = false;
        BeltTunnelTileEntity nextTunnel = BeltTunnelInteractionHandler.getTunnelOnSegment(beltInventory, upcomingSegment);
        int transferred = current.stack.m_41613_();
        if (nextTunnel instanceof BrassTunnelTileEntity) {
            BrassTunnelTileEntity brassTunnel = (BrassTunnelTileEntity)nextTunnel;
            if (brassTunnel.hasDistributionBehaviour()) {
                if (!brassTunnel.canTakeItems()) {
                    return true;
                }
                if (onServer) {
                    brassTunnel.setStackToDistribute(current.stack);
                    current.stack = ItemStack.f_41583_;
                    beltInventory.belt.sendData();
                    beltInventory.belt.m_6596_();
                }
                removed = true;
            }
        } else if (nextTunnel != null) {
            BlockState blockState = nextTunnel.m_58900_();
            if (current.stack.m_41613_() > 1 && AllBlocks.ANDESITE_TUNNEL.has(blockState) && BeltTunnelBlock.isJunction(blockState) && movementFacing.m_122434_() == blockState.m_61143_(BeltTunnelBlock.HORIZONTAL_AXIS)) {
                for (Direction d : Iterate.horizontalDirections) {
                    if (d.m_122434_() == blockState.m_61143_(BeltTunnelBlock.HORIZONTAL_AXIS) || !nextTunnel.flaps.containsKey(d)) continue;
                    BlockPos outpos = nextTunnel.m_58899_().m_7495_().m_142300_(d);
                    if (!world.m_46749_(outpos)) {
                        return true;
                    }
                    DirectBeltInputBehaviour behaviour = TileEntityBehaviour.get((BlockGetter)world, outpos, DirectBeltInputBehaviour.TYPE);
                    if (behaviour == null || !behaviour.canInsertFromSide(d)) continue;
                    ItemStack toinsert = ItemHandlerHelper.copyStackWithSize((ItemStack)current.stack, (int)1);
                    if (!behaviour.handleInsertion(toinsert, d, false).m_41619_()) {
                        return true;
                    }
                    if (onServer) {
                        BeltTunnelInteractionHandler.flapTunnel(beltInventory, upcomingSegment, d, false);
                    }
                    current.stack.m_41774_(1);
                    beltInventory.belt.sendData();
                    if (current.stack.m_41613_() <= 1) break;
                }
            }
        }
        if (onServer) {
            BeltTunnelInteractionHandler.flapTunnel(beltInventory, currentSegment, movementFacing, false);
            BeltTunnelInteractionHandler.flapTunnel(beltInventory, upcomingSegment, movementFacing.m_122424_(), true);
            if (nextTunnel != null) {
                DisplayLinkBlock.sendToGatherers((LevelAccessor)world, nextTunnel.m_58899_(), (dgte, b) -> b.itemReceived((DisplayLinkTileEntity)dgte, transferred), AccumulatedItemCountDisplaySource.class);
            }
        }
        return removed;
    }

    public static boolean stuckAtTunnel(BeltInventory beltInventory, int offset, ItemStack stack, Direction movementDirection) {
        BeltTileEntity belt = beltInventory.belt;
        BlockPos pos = BeltHelper.getPositionForOffset(belt, offset).m_7494_();
        if (!(belt.m_58904_().m_8055_(pos).m_60734_() instanceof BrassTunnelBlock)) {
            return false;
        }
        BlockEntity te = belt.m_58904_().m_7702_(pos);
        if (te == null || !(te instanceof BrassTunnelTileEntity)) {
            return false;
        }
        BrassTunnelTileEntity tunnel = (BrassTunnelTileEntity)te;
        return !tunnel.canInsert(movementDirection.m_122424_(), stack);
    }

    public static void flapTunnel(BeltInventory beltInventory, int offset, Direction side, boolean inward) {
        BeltTunnelTileEntity te = BeltTunnelInteractionHandler.getTunnelOnSegment(beltInventory, offset);
        if (te == null) {
            return;
        }
        te.flap(side, inward);
    }

    protected static BeltTunnelTileEntity getTunnelOnSegment(BeltInventory beltInventory, int offset) {
        BeltTileEntity belt = beltInventory.belt;
        if (belt.m_58900_().m_61143_(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL) {
            return null;
        }
        return BeltTunnelInteractionHandler.getTunnelOnPosition(belt.m_58904_(), BeltHelper.getPositionForOffset(belt, offset));
    }

    public static BeltTunnelTileEntity getTunnelOnPosition(Level world, BlockPos pos) {
        if (!(world.m_8055_(pos = pos.m_7494_()).m_60734_() instanceof BeltTunnelBlock)) {
            return null;
        }
        BlockEntity te = world.m_7702_(pos);
        if (te == null || !(te instanceof BeltTunnelTileEntity)) {
            return null;
        }
        return (BeltTunnelTileEntity)te;
    }
}

