/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.bell;

import com.simibubi.create.content.contraptions.components.actors.BellMovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.curiosities.bell.HauntedBellPulser;
import net.minecraft.core.BlockPos;

public class HauntedBellMovementBehaviour
extends BellMovementBehaviour {
    public static final int DISTANCE = 3;

    @Override
    public void tick(MovementContext context) {
        int recharge = this.getRecharge(context);
        if (recharge > 0) {
            this.setRecharge(context, recharge - 1);
        }
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        if (!context.world.f_46443_ && this.getRecharge(context) == 0) {
            HauntedBellPulser.sendPulse(context.world, pos, 3, false);
            this.setRecharge(context, 65);
            HauntedBellMovementBehaviour.playSound(context);
        }
    }

    @Override
    public void writeExtraData(MovementContext context) {
        context.tileData.m_128405_("Recharge", this.getRecharge(context));
    }

    private int getRecharge(MovementContext context) {
        if (!(context.temporaryData instanceof Integer) && context.world != null) {
            context.temporaryData = context.tileData.m_128451_("Recharge");
        }
        return (Integer)context.temporaryData;
    }

    private void setRecharge(MovementContext context, int value) {
        context.temporaryData = value;
    }
}

