/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.IRedstoneLinkable;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.behaviour.linked.LinkBehaviour;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.WorldHelper;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class RedstoneLinkNetworkHandler {
    static final Map<LevelAccessor, Map<Couple<Frequency>, Set<IRedstoneLinkable>>> connections = new IdentityHashMap<LevelAccessor, Map<Couple<Frequency>, Set<IRedstoneLinkable>>>();
    public final AtomicInteger globalPowerVersion = new AtomicInteger();

    public void onLoadWorld(LevelAccessor world) {
        connections.put(world, new HashMap());
        Create.LOGGER.debug("Prepared Redstone Network Space for " + WorldHelper.getDimensionID(world));
    }

    public void onUnloadWorld(LevelAccessor world) {
        connections.remove(world);
        Create.LOGGER.debug("Removed Redstone Network Space for " + WorldHelper.getDimensionID(world));
    }

    public Set<IRedstoneLinkable> getNetworkOf(LevelAccessor world, IRedstoneLinkable actor) {
        Couple<Frequency> key;
        Map<Couple<Frequency>, Set<IRedstoneLinkable>> networksInWorld = this.networksIn(world);
        if (!networksInWorld.containsKey(key = actor.getNetworkKey())) {
            networksInWorld.put(key, new LinkedHashSet());
        }
        return networksInWorld.get(key);
    }

    public void addToNetwork(LevelAccessor world, IRedstoneLinkable actor) {
        this.getNetworkOf(world, actor).add(actor);
        this.updateNetworkOf(world, actor);
    }

    public void removeFromNetwork(LevelAccessor world, IRedstoneLinkable actor) {
        Set<IRedstoneLinkable> network = this.getNetworkOf(world, actor);
        network.remove(actor);
        if (network.isEmpty()) {
            this.networksIn(world).remove(actor.getNetworkKey());
            return;
        }
        this.updateNetworkOf(world, actor);
    }

    public void updateNetworkOf(LevelAccessor world, IRedstoneLinkable actor) {
        LinkBehaviour linkBehaviour;
        Set<IRedstoneLinkable> network = this.getNetworkOf(world, actor);
        this.globalPowerVersion.incrementAndGet();
        int power = 0;
        Iterator<IRedstoneLinkable> iterator = network.iterator();
        while (iterator.hasNext()) {
            Level level;
            IRedstoneLinkable other = iterator.next();
            if (!other.isAlive()) {
                iterator.remove();
                continue;
            }
            if (!(world instanceof Level) || !(level = (Level)world).m_46749_(other.getLocation())) {
                iterator.remove();
                continue;
            }
            if (!RedstoneLinkNetworkHandler.withinRange(actor, other) || power >= 15) continue;
            power = Math.max(other.getTransmittedStrength(), power);
        }
        if (actor instanceof LinkBehaviour && (linkBehaviour = (LinkBehaviour)actor).isListening()) {
            linkBehaviour.newPosition = true;
            linkBehaviour.setReceivedStrength(power);
        }
        for (IRedstoneLinkable other : network) {
            if (other == actor || !other.isListening() || !RedstoneLinkNetworkHandler.withinRange(actor, other)) continue;
            other.setReceivedStrength(power);
        }
    }

    public static boolean withinRange(IRedstoneLinkable from, IRedstoneLinkable to) {
        if (from == to) {
            return true;
        }
        return from.getLocation().m_123314_((Vec3i)to.getLocation(), (double)((Integer)AllConfigs.SERVER.logistics.linkRange.get()).intValue());
    }

    public Map<Couple<Frequency>, Set<IRedstoneLinkable>> networksIn(LevelAccessor world) {
        if (!connections.containsKey(world)) {
            Create.LOGGER.warn("Tried to Access unprepared network space of " + WorldHelper.getDimensionID(world));
            return new HashMap<Couple<Frequency>, Set<IRedstoneLinkable>>();
        }
        return connections.get(world);
    }

    public boolean hasAnyLoadedPower(Couple<Frequency> frequency) {
        for (Map<Couple<Frequency>, Set<IRedstoneLinkable>> map : connections.values()) {
            Set<IRedstoneLinkable> set = map.get(frequency);
            if (set == null || set.isEmpty()) continue;
            for (IRedstoneLinkable link : set) {
                if (link.getTransmittedStrength() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static class Frequency {
        public static final Frequency EMPTY = new Frequency(ItemStack.f_41583_);
        private static final Map<Item, Frequency> simpleFrequencies = new IdentityHashMap<Item, Frequency>();
        private ItemStack stack;
        private Item item;
        private int color;

        public static Frequency of(ItemStack stack) {
            if (stack.m_41619_()) {
                return EMPTY;
            }
            if (!stack.m_41782_()) {
                return simpleFrequencies.computeIfAbsent(stack.m_41720_(), $ -> new Frequency(stack));
            }
            return new Frequency(stack);
        }

        private Frequency(ItemStack stack) {
            this.stack = stack;
            this.item = stack.m_41720_();
            CompoundTag displayTag = stack.m_41737_("display");
            this.color = displayTag != null && displayTag.m_128441_("color") ? displayTag.m_128451_("color") : -1;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public int hashCode() {
            return this.item.hashCode() * 31 ^ this.color;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof Frequency ? ((Frequency)obj).item == this.item && ((Frequency)obj).color == this.color : false;
        }
    }
}

