/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.foundation.mixin.accessor.ParticleEngineAccessor;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorldParticles;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.WorldSectionElement;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.tileEntity.IMultiTileContainer;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedClientWorld;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PonderWorld
extends SchematicWorld {
    public PonderScene scene;
    protected Map<BlockPos, BlockState> originalBlocks;
    protected Map<BlockPos, BlockEntity> originalTileEntities;
    protected Map<BlockPos, Integer> blockBreakingProgressions;
    protected List<Entity> originalEntities;
    private Supplier<ClientLevel> asClientWorld = Suppliers.memoize(() -> WrappedClientWorld.of(this));
    protected PonderWorldParticles particles;
    private final Map<ResourceLocation, ParticleProvider<?>> particleProviders;
    int overrideLight;
    Selection mask;

    public PonderWorld(BlockPos anchor, Level original) {
        super(anchor, original);
        this.originalBlocks = new HashMap<BlockPos, BlockState>();
        this.originalTileEntities = new HashMap<BlockPos, BlockEntity>();
        this.blockBreakingProgressions = new HashMap<BlockPos, Integer>();
        this.originalEntities = new ArrayList<Entity>();
        this.particles = new PonderWorldParticles(this);
        this.particleProviders = ((ParticleEngineAccessor)Minecraft.m_91087_().f_91061_).create$getProviders();
    }

    public void createBackup() {
        this.originalBlocks.clear();
        this.originalTileEntities.clear();
        this.blocks.forEach((k, v) -> this.originalBlocks.put((BlockPos)k, (BlockState)v));
        this.tileEntities.forEach((k, v) -> this.originalTileEntities.put((BlockPos)k, BlockEntity.m_155241_((BlockPos)k, (BlockState)((BlockState)this.blocks.get(k)), (CompoundTag)v.m_187480_())));
        this.entities.forEach(e -> EntityType.m_20642_((CompoundTag)e.serializeNBT(), (Level)this).ifPresent(this.originalEntities::add));
    }

    public void restore() {
        this.entities.clear();
        this.blocks.clear();
        this.tileEntities.clear();
        this.blockBreakingProgressions.clear();
        this.renderedTileEntities.clear();
        this.originalBlocks.forEach((k, v) -> this.blocks.put(k, v));
        this.originalTileEntities.forEach((k, v) -> {
            BlockEntity te = BlockEntity.m_155241_((BlockPos)k, (BlockState)this.originalBlocks.get(k), (CompoundTag)v.m_187480_());
            this.onTEadded(te, te.m_58899_());
            this.tileEntities.put(k, te);
            this.renderedTileEntities.add(te);
        });
        this.originalEntities.forEach(e -> EntityType.m_20642_((CompoundTag)e.serializeNBT(), (Level)this).ifPresent(this.entities::add));
        this.particles.clearEffects();
        this.fixControllerTileEntities();
    }

    public void restoreBlocks(Selection selection) {
        selection.forEach(p -> {
            if (this.originalBlocks.containsKey(p)) {
                this.blocks.put(p, this.originalBlocks.get(p));
            }
            if (this.originalTileEntities.containsKey(p)) {
                BlockEntity te = BlockEntity.m_155241_((BlockPos)p, (BlockState)this.originalBlocks.get(p), (CompoundTag)this.originalTileEntities.get(p).m_187480_());
                this.onTEadded(te, te.m_58899_());
                this.tileEntities.put(p, te);
            }
        });
        this.redraw();
    }

    private void redraw() {
        if (this.scene != null) {
            this.scene.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
        }
    }

    public void pushFakeLight(int light) {
        this.overrideLight = light;
    }

    public void popLight() {
        this.overrideLight = -1;
    }

    @Override
    public int m_45517_(LightLayer p_226658_1_, BlockPos p_226658_2_) {
        return this.overrideLight == -1 ? 15 : this.overrideLight;
    }

    public void setMask(Selection mask) {
        this.mask = mask;
    }

    public void clearMask() {
        this.mask = null;
    }

    @Override
    public BlockState m_8055_(BlockPos globalPos) {
        if (this.mask != null && !this.mask.test(globalPos.m_141950_((Vec3i)this.anchor))) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_8055_(globalPos);
    }

    public BlockGetter m_7925_(int p_225522_1_, int p_225522_2_) {
        return this;
    }

    public void renderEntities(PoseStack ms, SuperRenderTypeBuffer buffer, Camera ari, float pt) {
        Vec3 Vector3d = ari.m_90583_();
        double d0 = Vector3d.m_7096_();
        double d1 = Vector3d.m_7098_();
        double d2 = Vector3d.m_7094_();
        for (Entity entity : this.entities) {
            if (entity.f_19797_ == 0) {
                entity.f_19790_ = entity.m_20185_();
                entity.f_19791_ = entity.m_20186_();
                entity.f_19792_ = entity.m_20189_();
            }
            this.renderEntity(entity, d0, d1, d2, pt, ms, buffer);
        }
        buffer.draw(RenderType.m_110446_((ResourceLocation)InventoryMenu.f_39692_));
        buffer.draw(RenderType.m_110452_((ResourceLocation)InventoryMenu.f_39692_));
        buffer.draw(RenderType.m_110458_((ResourceLocation)InventoryMenu.f_39692_));
        buffer.draw(RenderType.m_110476_((ResourceLocation)InventoryMenu.f_39692_));
    }

    private void renderEntity(Entity entity, double x, double y, double z, float pt, PoseStack ms, MultiBufferSource buffer) {
        double d0 = Mth.m_14139_((double)pt, (double)entity.f_19790_, (double)entity.m_20185_());
        double d1 = Mth.m_14139_((double)pt, (double)entity.f_19791_, (double)entity.m_20186_());
        double d2 = Mth.m_14139_((double)pt, (double)entity.f_19792_, (double)entity.m_20189_());
        float f = Mth.m_14179_((float)pt, (float)entity.f_19859_, (float)entity.m_146908_());
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        int light = renderManager.m_114382_(entity).m_114505_(entity, pt);
        renderManager.m_114384_(entity, d0 - x, d1 - y, d2 - z, f, pt, ms, buffer, light);
    }

    public void renderParticles(PoseStack ms, MultiBufferSource buffer, Camera ari, float pt) {
        this.particles.renderParticles(ms, buffer, ari, pt);
    }

    public void tick() {
        this.particles.tick();
        Iterator iterator = this.entities.iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            ++entity.f_19797_;
            entity.f_19790_ = entity.m_20185_();
            entity.f_19791_ = entity.m_20186_();
            entity.f_19792_ = entity.m_20189_();
            entity.m_8119_();
            if (entity.m_20186_() <= -0.5) {
                entity.m_146870_();
            }
            if (entity.m_6084_()) continue;
            iterator.remove();
        }
    }

    public void m_7106_(ParticleOptions data, double x, double y, double z, double mx, double my, double mz) {
        this.addParticle(this.makeParticle(data, x, y, z, mx, my, mz));
    }

    public void m_7107_(ParticleOptions data, double x, double y, double z, double mx, double my, double mz) {
        this.m_7106_(data, x, y, z, mx, my, mz);
    }

    @Nullable
    private <T extends ParticleOptions> Particle makeParticle(T data, double x, double y, double z, double mx, double my, double mz) {
        ResourceLocation key = RegisteredObjects.getKeyOrThrow(data.m_6012_());
        ParticleProvider<?> particleProvider = this.particleProviders.get(key);
        return particleProvider == null ? null : particleProvider.m_6966_(data, this.asClientWorld.get(), x, y, z, mx, my, mz);
    }

    @Override
    public boolean m_7731_(BlockPos pos, BlockState arg1, int arg2) {
        return super.m_7731_(pos, arg1, arg2);
    }

    public void addParticle(Particle p) {
        if (p != null) {
            this.particles.addParticle(p);
        }
    }

    @Override
    protected void onTEadded(BlockEntity tileEntity, BlockPos pos) {
        super.onTEadded(tileEntity, pos);
        if (!(tileEntity instanceof SmartTileEntity)) {
            return;
        }
        SmartTileEntity smartTileEntity = (SmartTileEntity)tileEntity;
        smartTileEntity.markVirtual();
    }

    public void fixControllerTileEntities() {
        for (BlockEntity tileEntity : this.tileEntities.values()) {
            if (tileEntity instanceof BeltTileEntity) {
                BeltTileEntity beltTileEntity = (BeltTileEntity)tileEntity;
                if (!beltTileEntity.isController()) continue;
                BlockPos controllerPos = tileEntity.m_58899_();
                for (BlockPos blockPos : BeltBlock.getBeltChain(this, controllerPos)) {
                    BlockEntity tileEntity2 = this.m_7702_(blockPos);
                    if (!(tileEntity2 instanceof BeltTileEntity)) continue;
                    BeltTileEntity belt2 = (BeltTileEntity)tileEntity2;
                    belt2.setController(controllerPos);
                }
            }
            if (!(tileEntity instanceof IMultiTileContainer)) continue;
            IMultiTileContainer multiTile = (IMultiTileContainer)tileEntity;
            BlockPos lastKnown = multiTile.getLastKnownPos();
            BlockPos current = tileEntity.m_58899_();
            if (lastKnown == null || current == null || multiTile.isController() || lastKnown.equals((Object)current)) continue;
            BlockPos newControllerPos = multiTile.getController().m_141952_((Vec3i)current.m_141950_((Vec3i)lastKnown));
            multiTile.setController(newControllerPos);
        }
    }

    public void setBlockBreakingProgress(BlockPos pos, int damage) {
        if (damage == 0) {
            this.blockBreakingProgressions.remove(pos);
        } else {
            this.blockBreakingProgressions.put(pos, damage - 1);
        }
    }

    public Map<BlockPos, Integer> getBlockBreakingProgressions() {
        return this.blockBreakingProgressions;
    }

    public void addBlockDestroyEffects(BlockPos pos, BlockState state) {
        VoxelShape voxelshape = state.m_60808_((BlockGetter)this, pos);
        if (voxelshape.m_83281_()) {
            return;
        }
        AABB bb = voxelshape.m_83215_();
        double d1 = Math.min(1.0, bb.f_82291_ - bb.f_82288_);
        double d2 = Math.min(1.0, bb.f_82292_ - bb.f_82289_);
        double d3 = Math.min(1.0, bb.f_82293_ - bb.f_82290_);
        int i = Math.max(2, Mth.m_14165_((double)(d1 / 0.25)));
        int j = Math.max(2, Mth.m_14165_((double)(d2 / 0.25)));
        int k = Math.max(2, Mth.m_14165_((double)(d3 / 0.25)));
        for (int l = 0; l < i; ++l) {
            for (int i1 = 0; i1 < j; ++i1) {
                for (int j1 = 0; j1 < k; ++j1) {
                    double d4 = ((double)l + 0.5) / (double)i;
                    double d5 = ((double)i1 + 0.5) / (double)j;
                    double d6 = ((double)j1 + 0.5) / (double)k;
                    double d7 = d4 * d1 + bb.f_82288_;
                    double d8 = d5 * d2 + bb.f_82289_;
                    double d9 = d6 * d3 + bb.f_82290_;
                    this.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)pos.m_123341_() + d7, (double)pos.m_123342_() + d8, (double)pos.m_123343_() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5);
                }
            }
        }
    }

    @Override
    protected BlockState processBlockStateForPrinting(BlockState state) {
        return state;
    }

    public boolean m_46805_(BlockPos pos) {
        return true;
    }

    public boolean m_7232_(int x, int y) {
        return true;
    }

    public boolean m_46749_(BlockPos pos) {
        return true;
    }

    public boolean m_45914_(double p_217358_1_, double p_217358_3_, double p_217358_5_, double p_217358_7_) {
        return true;
    }
}

