/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.config;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;

public class HarvesterConfig {
    private final ForgeConfigSpec.BooleanValue enabled;
    private final ForgeConfigSpec.BooleanValue requiresTool;
    private final ForgeConfigSpec.BooleanValue takeReplantItem;
    private final ForgeConfigSpec.ConfigValue<String> validToolType;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> harvestBlacklist;
    private final ForgeConfigSpec.ConfigValue<String> replantItem;
    private final String name;

    public HarvesterConfig(String name, ForgeConfigSpec.Builder configBuilder, boolean enabled, boolean requiresTool, boolean takeReplantItem, ToolAction toolType, String replantDefault, List<Item> harvestBlacklist) {
        this.name = name;
        configBuilder.push(name);
        this.enabled = configBuilder.comment("If true, this harvester will be enabled.").translation(String.format("config.%s.%s.enabled", "quickharvest", name)).worldRestart().define("enabled", enabled);
        this.requiresTool = configBuilder.comment("If true, this harvester will require the set tool to function.").translation(String.format("config.%s.%s.requires_tool", "quickharvest", name)).worldRestart().define("requires_tool", requiresTool);
        this.takeReplantItem = configBuilder.comment("If true, this harvester will take a replant item when performing a quick harvest.").translation(String.format("config.%s.%s.take_replant_item", "quickharvest", name)).worldRestart().define("take_replant_item", takeReplantItem);
        this.validToolType = configBuilder.comment("A string representing the type of tool required to use the harvester.").comment("NOTE: Only works if 'require_tool' is set to true").comment("Recommended values: 'hoe', 'axe', 'shovel', 'pickaxe'").translation(String.format("config.%s.%s.valid_tool_type", "quickharvest", name)).define("valid_tool_type", (Object)(toolType == null ? "" : toolType.name()));
        this.replantItem = configBuilder.comment("The registry name of the item that is required to replant after a quick harvest.").comment("NOTE: This only works if 'take_replant_item' is true.").translation(String.format("config.%s.%s.replant_item", "quickharvest", name)).worldRestart().define("replant_item", (Object)replantDefault, str -> Objects.nonNull(str) && HarvesterConfig.isValidResourceLocationString((String)str));
        this.harvestBlacklist = configBuilder.comment("A List of strings representing the items which when held, this harvester will not work." + (harvestBlacklist.isEmpty() ? "" : String.format("%nRecommended values: %s", harvestBlacklist.stream().map(ForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).map(ResourceLocation::toString).map(s -> "\"" + s + "\"").collect(Collectors.toList()).toString()))).translation(String.format("config.%s.%s.harvest_blacklist", "quickharvest", name)).defineList("harvest_blacklist", harvestBlacklist.stream().map(ForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).map(ResourceLocation::toString).collect(Collectors.toList()), it -> ForgeRegistries.ITEMS.containsKey(new ResourceLocation((String)it)));
        configBuilder.pop();
    }

    public List<Item> getBlacklist() {
        return ((List)this.harvestBlacklist.get()).stream().map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).collect(Collectors.toList());
    }

    public boolean isEnabled() {
        return (Boolean)this.enabled.get();
    }

    public boolean requiresTool() {
        return (Boolean)this.requiresTool.get();
    }

    public boolean takesReplantItem() {
        return (Boolean)this.takeReplantItem.get();
    }

    public ToolAction getToolType() {
        String toolType = (String)this.validToolType.get();
        if (toolType.trim().isEmpty()) {
            return null;
        }
        return ToolAction.get((String)toolType);
    }

    public Item getReplantItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)this.replantItem.get()));
    }

    public String getName() {
        return this.name;
    }

    public static boolean isValidResourceLocationString(String resourceName) {
        String[] parts = HarvesterConfig.splitResourceLocationString(resourceName, ':');
        return HarvesterConfig.isValidResourceLocationNamespace(parts[0]) && HarvesterConfig.isValidResourceLocationPath(parts[1]);
    }

    public static boolean isValidResourceLocationNamespace(String namespace) {
        for (char ch : namespace.toCharArray()) {
            if (HarvesterConfig.isValidResourceLocationChar(ch, false)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidResourceLocationPath(String path) {
        for (char ch : path.toCharArray()) {
            if (HarvesterConfig.isValidResourceLocationChar(ch, true)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidResourceLocationChar(char ch, boolean isPath) {
        return ch == '_' || ch == '-' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '.' || ch == '/' && isPath;
    }

    public static String[] splitResourceLocationString(String name, char splitter) {
        String[] loc = new String[]{"minecraft", name};
        int splitterIndex = name.indexOf(splitter);
        if (splitterIndex >= 0) {
            loc[1] = name.substring(splitterIndex + 1);
            if (splitterIndex >= 1) {
                loc[0] = name.substring(0, splitterIndex);
            }
        }
        return loc;
    }
}

