/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.harvester;

import com.ewyboy.quickharvest.config.HarvesterConfig;
import com.ewyboy.quickharvest.harvester.AbstractHarvester;
import com.ewyboy.quickharvest.util.FloodFill;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class ChorusHarvester
extends AbstractHarvester {
    private static final Predicate<BlockState> fruit = s -> s.m_60734_() instanceof ChorusFlowerBlock;
    private static final Predicate<BlockState> notFruit = s -> s.m_60734_() instanceof ChorusPlantBlock;

    public ChorusHarvester(HarvesterConfig config) {
        super(config);
    }

    @Override
    public List<ItemStack> harvest(Player player, InteractionHand hand, ServerLevel world, BlockPos pos, BlockState state, Direction side) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        FloodFill floodFill = new FloodFill(pos, s -> fruit.or(notFruit).test((BlockState)s) ? Direction.values() : FloodFill.NO_DIRECTIONS, (Set<Predicate<BlockState>>)ImmutableSet.of(fruit, notFruit));
        int blocksBroken = 0;
        floodFill.search(world);
        for (Set<BlockInWorld> cachedBlockInfos : floodFill.getFoundTargets().values()) {
            blocksBroken += cachedBlockInfos.size();
            for (BlockInWorld info : cachedBlockInfos) {
                if (info.m_61168_() == null) continue;
                drops.addAll(Block.m_49869_((BlockState)info.m_61168_(), (ServerLevel)world, (BlockPos)info.m_61176_(), (BlockEntity)info.m_61174_()));
                world.m_46961_(info.m_61176_(), false);
            }
        }
        world.m_7731_(floodFill.getLowestPoint(), Blocks.f_50491_.m_49966_(), 7);
        this.damageTool(player, hand, blocksBroken);
        this.takeReplantItem(drops);
        return drops;
    }

    @Override
    protected boolean isEffectiveOn(BlockState state) {
        return fruit.or(notFruit).test(state);
    }
}

