/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.harvester;

import com.ewyboy.quickharvest.config.HarvesterConfig;
import com.ewyboy.quickharvest.harvester.AbstractHarvester;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StemPlantHarvester
extends AbstractHarvester {
    private final Block stem;
    private final Block fruit;

    public StemPlantHarvester(HarvesterConfig config, Block stem, Block fruit) {
        super(config);
        this.stem = stem;
        this.fruit = fruit;
    }

    @Override
    public List<ItemStack> harvest(Player player, InteractionHand hand, ServerLevel world, BlockPos pos, BlockState state, Direction side) {
        Block block = state.m_60734_();
        if (block == this.stem) {
            Direction grown = (Direction)state.m_61143_((Property)AttachedStemBlock.f_48830_);
            BlockPos fruitPos = pos.m_142300_(grown);
            BlockState fruitState = world.m_8055_(fruitPos);
            return this.breakFruit(player, hand, world, fruitPos, fruitState, grown.m_122424_());
        }
        return this.breakFruit(player, hand, world, pos, state, side);
    }

    private List<ItemStack> breakFruit(Player player, InteractionHand hand, ServerLevel world, BlockPos pos, BlockState state, Direction side) {
        this.damageTool(player, hand, 1);
        world.m_46961_(pos, false);
        return Block.m_49869_((BlockState)state, (ServerLevel)world, (BlockPos)pos, null);
    }

    @Override
    protected boolean isEffectiveOn(BlockState state) {
        Block block = state.m_60734_();
        return block == this.stem || block == this.fruit;
    }
}

