/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.harvester;

import com.ewyboy.quickharvest.config.HarvesterConfig;
import com.ewyboy.quickharvest.harvester.AbstractHarvester;
import com.ewyboy.quickharvest.util.FloodFill;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class TallPlantHarvester
extends AbstractHarvester {
    private final Predicate<BlockState> plantPredicate = this::isEffectiveOn;
    private final Block plant;

    public TallPlantHarvester(HarvesterConfig config, Block plant) {
        super(config);
        this.plant = plant;
    }

    @Override
    public List<ItemStack> harvest(Player player, InteractionHand hand, ServerLevel world, BlockPos pos, BlockState state, Direction side) {
        FloodFill floodFill = new FloodFill(pos, s -> {
            Direction[] directionArray;
            if (this.plantPredicate.test((BlockState)s)) {
                Direction[] directionArray2 = new Direction[2];
                directionArray2[0] = Direction.UP;
                directionArray = directionArray2;
                directionArray2[1] = Direction.DOWN;
            } else {
                directionArray = FloodFill.NO_DIRECTIONS;
            }
            return directionArray;
        }, (Set<Predicate<BlockState>>)ImmutableSet.of(this.plantPredicate));
        floodFill.search(world);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Set<BlockInWorld> matches = floodFill.getFoundTargets().get(this.plantPredicate);
        for (BlockInWorld info : matches) {
            if (info.m_61176_().equals((Object)floodFill.getLowestPoint())) continue;
            info.m_61168_();
            drops.addAll(Block.m_49869_((BlockState)info.m_61168_(), (ServerLevel)world, (BlockPos)info.m_61176_(), (BlockEntity)info.m_61174_()));
            world.m_46961_(info.m_61176_(), false);
        }
        this.damageTool(player, hand, matches.size() - 1);
        return drops;
    }

    @Override
    protected boolean isEffectiveOn(BlockState state) {
        return state.m_60734_() == this.plant;
    }
}

