/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.item;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.addons.oddities.module.TotemOfHoldingModule;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.QuarkModule;

public class SoulCompassItem
extends QuarkItem {
    private static final String TAG_POS_X = "posX";
    private static final String TAG_DIMENSION_ID = "dimensionID";
    private static final String TAG_POS_Z = "posZ";
    @OnlyIn(value=Dist.CLIENT)
    private static double rotation;
    @OnlyIn(value=Dist.CLIENT)
    private static double rota;
    @OnlyIn(value=Dist.CLIENT)
    private static long lastUpdateTick;

    public SoulCompassItem(QuarkModule module) {
        super("soul_compass", module, new Item.Properties().m_41491_(CreativeModeTab.f_40756_).m_41487_(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float angle(ItemStack stack, ClientLevel world, LivingEntity entityIn, int i) {
        double angle;
        LivingEntity entity;
        if (entityIn == null && !stack.m_41794_()) {
            return 0.0f;
        }
        boolean hasEntity = entityIn != null;
        Object object = entity = hasEntity ? entityIn : stack.m_41795_();
        if (entity == null) {
            return 0.0f;
        }
        if (world == null && entity != null && entity.f_19853_ instanceof ClientLevel) {
            world = (ClientLevel)entity.f_19853_;
        }
        BlockPos pos = SoulCompassItem.getPos(stack);
        if (SoulCompassItem.getDim(stack).equals(world.m_46472_().m_135782_().toString())) {
            double yaw = hasEntity ? (double)entity.m_146908_() : SoulCompassItem.getFrameRotation((ItemFrame)entity);
            yaw = Mth.m_14109_((double)(yaw / 360.0), (double)1.0);
            double relAngle = SoulCompassItem.getDeathToAngle((Entity)entity, pos) / (Math.PI * 2);
            angle = 0.5 - (yaw - 0.25 - relAngle);
        } else {
            angle = Math.random();
        }
        if (hasEntity) {
            angle = SoulCompassItem.wobble((Level)world, angle);
        }
        return Mth.m_14091_((float)((float)angle), (float)1.0f);
    }

    public void m_6883_(@Nonnull ItemStack stack, Level worldIn, @Nonnull Entity entityIn, int itemSlot, boolean isSelected) {
        Pair<BlockPos, String> deathPos;
        if (!worldIn.f_46443_ && (deathPos = TotemOfHoldingModule.getPlayerDeathPosition(entityIn)) != null) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_X, (int)((BlockPos)deathPos.getFirst()).m_123341_());
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_POS_Z, (int)((BlockPos)deathPos.getFirst()).m_123343_());
            ItemNBTHelper.setString((ItemStack)stack, (String)TAG_DIMENSION_ID, (String)((String)deathPos.getSecond()));
        }
    }

    private static BlockPos getPos(ItemStack stack) {
        if (stack.m_41782_()) {
            int x = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_X, (int)0);
            int y = -1;
            int z = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_POS_Z, (int)0);
            return new BlockPos(x, y, z);
        }
        return new BlockPos(0, -1, 0);
    }

    private static String getDim(ItemStack stack) {
        if (stack.m_41782_()) {
            return ItemNBTHelper.getString((ItemStack)stack, (String)TAG_DIMENSION_ID, (String)"");
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    private static double wobble(Level worldIn, double angle) {
        if (worldIn.m_46467_() != lastUpdateTick) {
            lastUpdateTick = worldIn.m_46467_();
            double relAngle = angle - rotation;
            relAngle = Mth.m_14109_((double)(relAngle + 0.5), (double)1.0) - 0.5;
            rota += relAngle * 0.1;
            rotation = Mth.m_14109_((double)(rotation + (rota *= 0.8)), (double)1.0);
        }
        return rotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static double getFrameRotation(ItemFrame frame) {
        Direction facing = frame.m_6350_();
        return Mth.m_14177_((float)(180.0f + facing.m_122435_()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static double getDeathToAngle(Entity entity, BlockPos blockpos) {
        return Math.atan2((double)blockpos.m_123343_() - entity.m_20189_(), (double)blockpos.m_123341_() - entity.m_20185_());
    }
}

