/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.MiscUtil;

public final class OverrideRegistryHandler {
    public static void registerBlock(Block block, String baseName, @Nullable CreativeModeTab group) {
        OverrideRegistryHandler.register(block, Blocks.class, baseName);
        OverrideRegistryHandler.registerBlockItem(block, group);
    }

    private static void registerBlockItem(Block block, @Nullable CreativeModeTab group) {
        Item.Properties props = new Item.Properties();
        if (group != null) {
            props = props.m_41491_(group);
        }
        BlockItem item = new BlockItem(block, props);
        OverrideRegistryHandler.registerItem((Item)item, block.getRegistryName().m_135815_());
    }

    public static void registerItem(Item item, String baseName) {
        OverrideRegistryHandler.register(item, Items.class, baseName);
    }

    public static <T extends ForgeRegistryEntry<T>> void register(T obj, Class<?> registryType, String baseName) {
        ResourceLocation regName = new ResourceLocation("minecraft", baseName);
        try {
            Field field = ForgeRegistryEntry.class.getDeclaredField("registryName");
            field.setAccessible(true);
            field.set(obj, regName);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            obj.setRegistryName(regName);
        }
        RegistryHelper.register(obj);
        for (Field declared : registryType.getDeclaredFields()) {
            if (!Modifier.isStatic(declared.getModifiers()) || !obj.getClass().isAssignableFrom(declared.getType())) continue;
            try {
                IForgeRegistryEntry fieldVal = (IForgeRegistryEntry)declared.get(null);
                if (!regName.equals((Object)fieldVal.getRegistryName())) continue;
                if (obj instanceof Block && fieldVal instanceof Block) {
                    itemMap = GameData.getBlockItemMap();
                    itemMap.put((Block)obj, (Item)itemMap.get(fieldVal));
                } else if (obj instanceof BlockItem) {
                    itemMap = GameData.getBlockItemMap();
                    itemMap.put(((BlockItem)obj).m_40614_(), (Item)obj);
                }
                Quark.LOG.info("Overriding " + registryType + "." + declared + " with " + obj);
                MiscUtil.editFinalField(declared, null, obj);
            }
            catch (IllegalAccessException e) {
                Quark.LOG.warn("Was unable to replace registry entry for " + regName + ", may cause issues", (Throwable)e);
            }
        }
    }
}

