/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.AbstractConfigType;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true)
public class PathfinderMapsModule
extends QuarkModule {
    private static final Object mutex = new Object();
    public static List<TradeInfo> builtinTrades = new LinkedList<TradeInfo>();
    public static List<TradeInfo> customTrades = new LinkedList<TradeInfo>();
    public static List<TradeInfo> tradeList = new LinkedList<TradeInfo>();
    @Config(description="In this section you can add custom Pathfinder Maps. This works for both vanilla and modded biomes.\nEach custom map must be on its own line.\nThe format for a custom map is as follows:\n<id>,<level>,<min_price>,<max_price>,<color>,<name>\n\nWith the following descriptions:\n - <id> being the biome's ID NAME. You can find vanilla names here - https://minecraft.gamepedia.com/Biome#Biome_IDs\n - <level> being the Cartographer villager level required for the map to be unlockable\n - <min_price> being the cheapest (in Emeralds) the map can be\n - <max_price> being the most expensive (in Emeralds) the map can be\n - <color> being a hex color (without the #) for the map to display. You can generate one here - https://htmlcolorcodes.com/\n - <name> being the display name of the map\n\nHere's an example of a map to locate Ice Mountains:\nminecraft:ice_mountains,2,8,14,7FE4FF,Ice Mountains Pathfinder Map")
    private List<String> customs = new LinkedList<String>();
    @Config
    public static int searchRadius = 6400;
    @Config
    public static int searchDistanceIncrement = 8;
    @Config
    public static int xpFromTrade = 5;

    private static String getBiomeDescriptor(ResourceLocation rl) {
        if (rl == null) {
            return "unknown";
        }
        return rl.m_135815_();
    }

    @Override
    public void register() {
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_186761_, true, 4, 8, 14, 8381695);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_186765_, true, 4, 8, 14, 0x8A8A8A);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48151_, true, 4, 8, 14, 22794);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48203_, true, 4, 8, 14, 13416782);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48157_, true, 4, 8, 14, 10200418);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48207_, true, 4, 12, 18, 2242319);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_186763_, true, 4, 12, 18, 5980703);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48179_, true, 5, 12, 18, 14449642);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48222_, true, 5, 16, 22, 2274816);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48197_, true, 5, 16, 22, 4055575);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48159_, true, 5, 16, 22, 13008674);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48215_, true, 5, 20, 26, 5063283);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48182_, true, 5, 20, 26, 4314825);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onTradesLoaded(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.f_35588_) {
            Object object = mutex;
            synchronized (object) {
                Int2ObjectMap trades = event.getTrades();
                for (TradeInfo info : tradeList) {
                    if (info == null) continue;
                    ((List)trades.get(info.level)).add(new PathfinderMapTrade(info));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configChanged() {
        Object object = mutex;
        synchronized (object) {
            tradeList.clear();
            customTrades.clear();
            this.loadCustomMaps(this.customs);
            tradeList.addAll(builtinTrades);
            tradeList.addAll(customTrades);
        }
    }

    private void loadTradeInfo(ResourceKey<Biome> biome, boolean enabled, int level, int minPrice, int maxPrice, int color) {
        builtinTrades.add(new TradeInfo(biome.m_135782_(), enabled, level, minPrice, maxPrice, color));
    }

    private void loadCustomTradeInfo(ResourceLocation biome, boolean enabled, int level, int minPrice, int maxPrice, int color, String name) {
        customTrades.add(new TradeInfo(biome, enabled, level, minPrice, maxPrice, color, name));
    }

    private void loadCustomTradeInfo(String line) throws IllegalArgumentException {
        String[] tokens = line.split(",");
        if (tokens.length != 6) {
            throw new IllegalArgumentException("Wrong number of parameters " + tokens.length + " (expected 6)");
        }
        ResourceLocation biomeName = new ResourceLocation(tokens[0]);
        int level = Integer.parseInt(tokens[1]);
        int minPrice = Integer.parseInt(tokens[2]);
        int maxPrice = Integer.parseInt(tokens[3]);
        int color = Integer.parseInt(tokens[4], 16);
        String name = tokens[5];
        this.loadCustomTradeInfo(biomeName, true, level, minPrice, maxPrice, color, name);
    }

    private void loadCustomMaps(Iterable<String> lines) {
        for (String s : lines) {
            try {
                this.loadCustomTradeInfo(s);
            }
            catch (IllegalArgumentException e) {
                Quark.LOG.warn("[Custom Pathfinder Maps] Error while reading custom map string \"{}\"", (Object)s);
                Quark.LOG.warn("[Custom Pathfinder Maps] - {}", (Object)e.getMessage());
            }
        }
    }

    public static ItemStack createMap(Level world, BlockPos pos, TradeInfo info) {
        if (!(world instanceof ServerLevel)) {
            return ItemStack.f_41583_;
        }
        BlockPos biomePos = MiscUtil.locateBiome((ServerLevel)world, info.biome, pos, searchRadius, searchDistanceIncrement);
        if (biomePos == null) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = MapItem.m_42886_((Level)world, (int)biomePos.m_123341_(), (int)biomePos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
        MapItem.m_42850_((ServerLevel)((ServerLevel)world), (ItemStack)stack);
        MapItemSavedData.m_77925_((ItemStack)stack, (BlockPos)biomePos, (String)"+", (MapDecoration.Type)MapDecoration.Type.RED_X);
        stack.m_41714_((Component)new TranslatableComponent(info.name));
        return stack;
    }

    public static class TradeInfo
    extends AbstractConfigType {
        public final ResourceLocation biome;
        public final int color;
        public final String name;
        @Config
        public boolean enabled;
        @Config
        public final int level;
        @Config
        public final int minPrice;
        @Config
        public final int maxPrice;

        TradeInfo(ResourceLocation biome, boolean enabled, int level, int minPrice, int maxPrice, int color) {
            this(biome, enabled, level, minPrice, maxPrice, color, "item.quark.biome_map." + PathfinderMapsModule.getBiomeDescriptor(biome));
        }

        TradeInfo(ResourceLocation biome, boolean enabled, int level, int minPrice, int maxPrice, int color, String name) {
            this.biome = biome;
            this.enabled = enabled;
            this.level = level;
            this.minPrice = minPrice;
            this.maxPrice = maxPrice;
            this.color = color;
            this.name = name;
        }
    }

    private record PathfinderMapTrade(TradeInfo info) implements VillagerTrades.ItemListing
    {
        public MerchantOffer m_5670_(@Nonnull Entity entity, @Nonnull Random random) {
            if (!this.info.enabled) {
                return null;
            }
            int i = random.nextInt(this.info.maxPrice - this.info.minPrice + 1) + this.info.minPrice;
            ItemStack itemstack = PathfinderMapsModule.createMap(entity.f_19853_, entity.m_142538_(), this.info);
            if (itemstack.m_41619_()) {
                return null;
            }
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, i), new ItemStack((ItemLike)Items.f_42522_), itemstack, 12, xpFromTrade * Math.max(1, this.info.level - 1), 0.2f);
        }
    }
}

