/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.base.handler.RayTraceHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.inputtable.RGBColorConfig;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class ReacharoundPlacingModule
extends QuarkModule {
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=1.0)
    public double leniency = 0.5;
    @Config
    public List<String> whitelist = Lists.newArrayList();
    @Config
    public List<String> blacklist = Lists.newArrayList();
    @Config
    public String display = "[  ]";
    @Config
    public String displayHorizontal = "<  >";
    @Config
    public RGBColorConfig color = RGBColorConfig.forColor(1.0, 1.0, 1.0);
    private ReacharoundTarget currentTarget;
    private int ticksDisplayed;
    public static TagKey<Item> reacharoundTag;

    @Override
    public void setup() {
        reacharoundTag = ItemTags.create((ResourceLocation)new ResourceLocation("quark", "reacharound_able"));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRender(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (mc.f_91066_.f_92062_) {
            return;
        }
        if (player != null && this.currentTarget != null) {
            Window res = event.getWindow();
            PoseStack matrix = event.getMatrixStack();
            String text = this.currentTarget.dir.m_122434_() == Direction.Axis.Y ? this.display : this.displayHorizontal;
            matrix.m_85836_();
            matrix.m_85837_((double)((float)res.m_85445_() / 2.0f), (double)((float)res.m_85446_() / 2.0f - 4.0f), 0.0);
            float scale = Math.min(5.0f, (float)this.ticksDisplayed + event.getPartialTicks()) / 5.0f;
            scale *= scale;
            int opacity = (int)(255.0f * scale) << 24;
            matrix.m_85841_(scale, 1.0f, 1.0f);
            matrix.m_85837_((double)((float)(-mc.f_91062_.m_92895_(text)) / 2.0f), 0.0, 0.0);
            mc.f_91062_.m_92883_(matrix, text, 0.0f, 0.0f, this.color.getColor() | opacity);
            matrix.m_85849_();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.currentTarget = null;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                this.currentTarget = this.getPlayerReacharoundTarget((Player)player);
            }
            if (this.currentTarget != null) {
                if (this.ticksDisplayed < 5) {
                    ++this.ticksDisplayed;
                }
            } else {
                this.ticksDisplayed = 0;
            }
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getPlayer();
        ReacharoundTarget target = this.getPlayerReacharoundTarget(player);
        if (target != null && event.getHand() == target.hand) {
            InteractionResult res;
            ItemStack stack = event.getItemStack();
            if (!player.m_36204_(target.pos, target.dir, stack)) {
                return;
            }
            int count = stack.m_41613_();
            InteractionHand hand = event.getHand();
            UseOnContext context = new UseOnContext(player, hand, new BlockHitResult(new Vec3(0.5, 1.0, 0.5), target.dir, target.pos, false));
            boolean remote = player.f_19853_.f_46443_;
            Item item = stack.m_41720_();
            InteractionResult interactionResult = res = remote ? InteractionResult.SUCCESS : item.m_6225_(context);
            if (res != InteractionResult.PASS) {
                event.setCanceled(true);
                event.setCancellationResult(res);
                if (res == InteractionResult.SUCCESS) {
                    player.m_6674_(hand);
                } else if (res == InteractionResult.CONSUME) {
                    BlockPos placedPos = target.pos;
                    BlockState state = player.f_19853_.m_8055_(placedPos);
                    SoundType soundtype = state.getSoundType((LevelReader)player.f_19853_, placedPos, (Entity)context.m_43723_());
                    if (player.f_19853_ instanceof ServerLevel) {
                        player.f_19853_.m_5594_(null, placedPos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                    }
                }
                if (player.m_150110_().f_35937_ && stack.m_41613_() < count && !remote) {
                    stack.m_41764_(count);
                }
            }
        }
    }

    private ReacharoundTarget getPlayerReacharoundTarget(Player player) {
        Vec3 ray;
        InteractionHand hand = null;
        if (this.validateReacharoundStack(player.m_21205_())) {
            hand = InteractionHand.MAIN_HAND;
        } else if (this.validateReacharoundStack(player.m_21206_())) {
            hand = InteractionHand.OFF_HAND;
        }
        if (hand == null) {
            return null;
        }
        Level world = player.f_19853_;
        Pair<Vec3, Vec3> params = RayTraceHandler.getEntityParams((Entity)player);
        double range = RayTraceHandler.getEntityRange((LivingEntity)player);
        Vec3 rayPos = (Vec3)params.getLeft();
        HitResult normalRes = RayTraceHandler.rayTrace((Entity)player, world, rayPos, ray = ((Vec3)params.getRight()).m_82490_(range), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE);
        if (normalRes.m_6662_() == HitResult.Type.MISS) {
            ReacharoundTarget target = this.getPlayerVerticalReacharoundTarget(player, hand, world, rayPos, ray);
            if (target != null) {
                return target;
            }
            target = this.getPlayerHorizontalReacharoundTarget(player, hand, world, rayPos, ray);
            return target;
        }
        return null;
    }

    private ReacharoundTarget getPlayerVerticalReacharoundTarget(Player player, InteractionHand hand, Level world, Vec3 rayPos, Vec3 ray) {
        if (player.m_146909_() < 0.0f) {
            return null;
        }
        HitResult take2Res = RayTraceHandler.rayTrace((Entity)player, world, rayPos = rayPos.m_82520_(0.0, this.leniency, 0.0), ray, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE);
        if (take2Res.m_6662_() == HitResult.Type.BLOCK && take2Res instanceof BlockHitResult) {
            BlockPos pos = ((BlockHitResult)take2Res).m_82425_().m_7495_();
            BlockState state = world.m_8055_(pos);
            if (player.m_20182_().f_82480_ - (double)pos.m_123342_() > 1.0 && (world.m_46859_(pos) || state.m_60767_().m_76336_())) {
                return new ReacharoundTarget(pos, Direction.DOWN, hand);
            }
        }
        return null;
    }

    private ReacharoundTarget getPlayerHorizontalReacharoundTarget(Player player, InteractionHand hand, Level world, Vec3 rayPos, Vec3 ray) {
        Direction dir = Direction.m_122364_((double)player.m_146908_());
        HitResult take2Res = RayTraceHandler.rayTrace((Entity)player, world, rayPos = rayPos.m_82492_(this.leniency * (double)dir.m_122429_(), 0.0, this.leniency * (double)dir.m_122431_()), ray, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE);
        if (take2Res.m_6662_() == HitResult.Type.BLOCK && take2Res instanceof BlockHitResult) {
            BlockPos pos = ((BlockHitResult)take2Res).m_82425_().m_142300_(dir);
            BlockState state = world.m_8055_(pos);
            if (world.m_46859_(pos) || state.m_60767_().m_76336_()) {
                return new ReacharoundTarget(pos, dir.m_122424_(), hand);
            }
        }
        return null;
    }

    private boolean validateReacharoundStack(ItemStack stack) {
        Item item = stack.m_41720_();
        String name = Objects.toString(item.getRegistryName());
        if (this.blacklist.contains(name)) {
            return false;
        }
        return item instanceof BlockItem || stack.m_204117_(reacharoundTag) || this.whitelist.contains(name);
    }

    private record ReacharoundTarget(BlockPos pos, Direction dir, InteractionHand hand) {
    }
}

