/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.EditSignMessage;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class SignEditingModule
extends QuarkModule {
    @Config
    public static boolean requiresEmptyHand = false;

    @OnlyIn(value=Dist.CLIENT)
    public static void openSignGuiClient(BlockPos pos) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(SignEditingModule.class)) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        BlockEntity tile = mc.f_91073_.m_7702_(pos);
        if (tile instanceof SignBlockEntity) {
            mc.f_91074_.m_7739_((SignBlockEntity)tile);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getUseBlock() == Event.Result.DENY) {
            return;
        }
        BlockEntity tile = event.getWorld().m_7702_(event.getPos());
        Player player = event.getPlayer();
        ItemStack stack = player.m_21205_();
        if (player instanceof ServerPlayer && tile instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)tile;
            if (!(this.doesSignHaveCommand((SignBlockEntity)tile) || requiresEmptyHand && !stack.m_41619_() || stack.m_41720_() instanceof DyeItem || stack.m_41720_() == Items.f_151056_ || tile.m_58900_().m_60734_().getRegistryName().m_135827_().equals("signbutton") || !player.m_36204_(event.getPos(), event.getFace(), event.getItemStack()) || event.getEntity().m_20163_())) {
                sign.m_155713_(player.m_142081_());
                sign.f_59721_ = true;
                QuarkNetwork.sendToPlayer(new EditSignMessage(event.getPos()), (ServerPlayer)player);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    private boolean doesSignHaveCommand(SignBlockEntity sign) {
        for (Component itextcomponent : sign.f_59720_) {
            ClickEvent clickevent;
            Style style;
            Style style2 = style = itextcomponent == null ? null : itextcomponent.m_7383_();
            if (style == null || style.m_131182_() == null || (clickevent = style.m_131182_()).m_130622_() != ClickEvent.Action.RUN_COMMAND) continue;
            return true;
        }
        return false;
    }
}

