/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.client.asset_generators;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockStateBuilder {
    private final Block block;
    private final Map<Map<Property<?>, Comparable<?>>, ModelConfiguration> blockModelMappings = new HashMap();

    public BlockStateBuilder(Block block) {
        this.block = block;
    }

    public static BlockStateBuilder forAllStatesExcept(Block block, Function<BlockState, ModelConfiguration> modelLocationProvider, Property<?> ... ignored) {
        BlockStateBuilder builder = new BlockStateBuilder(block);
        BlockState defaultState = block.m_49966_();
        HashSet seen = new HashSet();
        block0: for (BlockState fullState : block.m_49965_().m_61056_()) {
            LinkedHashMap propertyValues = Maps.newLinkedHashMap((Map)fullState.m_61148_());
            for (Property<?> p : ignored) {
                if (propertyValues.get(p) != defaultState.m_61143_(p)) continue block0;
                propertyValues.remove(p);
            }
            builder.setModel(propertyValues, modelLocationProvider.apply(fullState));
        }
        return builder;
    }

    public BlockStateBuilder setModel(Map<Property<?>, Comparable<?>> properties, ModelConfiguration modelLocation) {
        this.blockModelMappings.put(properties, modelLocation);
        return this;
    }

    public JsonObject build() {
        JsonObject main = new JsonObject();
        JsonObject variants = new JsonObject();
        for (Map.Entry<Map<Property<?>, Comparable<?>>, ModelConfiguration> entry : this.blockModelMappings.entrySet()) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<Property<?>, Comparable<?>> v : entry.getKey().entrySet()) {
                builder.append(v.getKey().m_61708_()).append("=").append(v.getValue());
            }
            variants.add(builder.toString(), (JsonElement)entry.getValue().toJson());
        }
        main.add("variants", (JsonElement)variants);
        return main;
    }

    public static class ModelConfiguration {
        public final ResourceLocation modelLocation;
        public int xRot = 0;
        public int yRot = 0;
        public boolean uvLock = false;

        public ModelConfiguration(ResourceLocation modelLocation) {
            this.modelLocation = modelLocation;
        }

        public JsonObject toJson() {
            JsonObject model = new JsonObject();
            model.addProperty("model", this.modelLocation.toString());
            if (this.xRot != 0) {
                model.addProperty("x", (Number)this.xRot);
            }
            if (this.yRot != 0) {
                model.addProperty("y", (Number)this.xRot);
            }
            if (this.uvLock) {
                model.addProperty("uvlock", Boolean.valueOf(true));
            }
            return model;
        }
    }
}

