/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api;

import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.lua.GenericSource;
import dan200.computercraft.api.lua.ILuaAPIFactory;
import dan200.computercraft.api.media.IMediaProvider;
import dan200.computercraft.api.network.IPacketNetwork;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.network.wired.IWiredNode;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.api.redstone.IBundledRedstoneProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public final class ComputerCraftAPI {
    public static final String MOD_ID = "computercraft";
    private static IComputerCraftAPI instance;

    @Nonnull
    public static String getInstalledVersion() {
        return ComputerCraftAPI.getInstance().getInstalledVersion();
    }

    public static int createUniqueNumberedSaveDir(@Nonnull Level world, @Nonnull String parentSubPath) {
        return ComputerCraftAPI.getInstance().createUniqueNumberedSaveDir(world, parentSubPath);
    }

    @Nullable
    public static IWritableMount createSaveDirMount(@Nonnull Level world, @Nonnull String subPath, long capacity) {
        return ComputerCraftAPI.getInstance().createSaveDirMount(world, subPath, capacity);
    }

    @Nullable
    public static IMount createResourceMount(@Nonnull String domain, @Nonnull String subPath) {
        return ComputerCraftAPI.getInstance().createResourceMount(domain, subPath);
    }

    public static void registerPeripheralProvider(@Nonnull IPeripheralProvider provider) {
        ComputerCraftAPI.getInstance().registerPeripheralProvider(provider);
    }

    public static void registerGenericSource(@Nonnull GenericSource source) {
        ComputerCraftAPI.getInstance().registerGenericSource(source);
    }

    public static void registerGenericCapability(@Nonnull Capability<?> capability) {
        ComputerCraftAPI.getInstance().registerGenericCapability(capability);
    }

    public static void registerBundledRedstoneProvider(@Nonnull IBundledRedstoneProvider provider) {
        ComputerCraftAPI.getInstance().registerBundledRedstoneProvider(provider);
    }

    public static int getBundledRedstoneOutput(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return ComputerCraftAPI.getInstance().getBundledRedstoneOutput(world, pos, side);
    }

    public static void registerMediaProvider(@Nonnull IMediaProvider provider) {
        ComputerCraftAPI.getInstance().registerMediaProvider(provider);
    }

    public static IPacketNetwork getWirelessNetwork() {
        return ComputerCraftAPI.getInstance().getWirelessNetwork();
    }

    public static void registerAPIFactory(@Nonnull ILuaAPIFactory factory) {
        ComputerCraftAPI.getInstance().registerAPIFactory(factory);
    }

    @Nonnull
    public static IWiredNode createWiredNodeForElement(@Nonnull IWiredElement element) {
        return ComputerCraftAPI.getInstance().createWiredNodeForElement(element);
    }

    @Nonnull
    public static LazyOptional<IWiredElement> getWiredElementAt(@Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return ComputerCraftAPI.getInstance().getWiredElementAt(world, pos, side);
    }

    @Nonnull
    private static IComputerCraftAPI getInstance() {
        if (instance != null) {
            return instance;
        }
        try {
            instance = (IComputerCraftAPI)Class.forName("dan200.computercraft.ComputerCraftAPIImpl").getField("INSTANCE").get(null);
            return instance;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Cannot find ComputerCraft API", e);
        }
    }

    public static interface IComputerCraftAPI {
        @Nonnull
        public String getInstalledVersion();

        public int createUniqueNumberedSaveDir(@Nonnull Level var1, @Nonnull String var2);

        @Nullable
        public IWritableMount createSaveDirMount(@Nonnull Level var1, @Nonnull String var2, long var3);

        @Nullable
        public IMount createResourceMount(@Nonnull String var1, @Nonnull String var2);

        public void registerPeripheralProvider(@Nonnull IPeripheralProvider var1);

        public void registerGenericSource(@Nonnull GenericSource var1);

        public void registerGenericCapability(@Nonnull Capability<?> var1);

        public void registerBundledRedstoneProvider(@Nonnull IBundledRedstoneProvider var1);

        public int getBundledRedstoneOutput(@Nonnull Level var1, @Nonnull BlockPos var2, @Nonnull Direction var3);

        public void registerMediaProvider(@Nonnull IMediaProvider var1);

        @Nonnull
        public IPacketNetwork getWirelessNetwork();

        public void registerAPIFactory(@Nonnull ILuaAPIFactory var1);

        @Nonnull
        public IWiredNode createWiredNodeForElement(@Nonnull IWiredElement var1);

        @Nonnull
        public LazyOptional<IWiredElement> getWiredElementAt(@Nonnull BlockGetter var1, @Nonnull BlockPos var2, @Nonnull Direction var3);
    }
}

