/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaValues;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TableHelper {
    private TableHelper() {
        throw new IllegalStateException("Cannot instantiate singleton " + this.getClass().getName());
    }

    @Nonnull
    public static LuaException badKey(@Nonnull String key, @Nonnull String expected, @Nullable Object actual) {
        return TableHelper.badKey(key, expected, LuaValues.getType(actual));
    }

    @Nonnull
    public static LuaException badKey(@Nonnull String key, @Nonnull String expected, @Nonnull String actual) {
        return new LuaException("bad field '" + key + "' (" + expected + " expected, got " + actual + ")");
    }

    public static double getNumberField(@Nonnull Map<?, ?> table, @Nonnull String key) throws LuaException {
        Object value = table.get(key);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw TableHelper.badKey(key, "number", value);
    }

    public static int getIntField(@Nonnull Map<?, ?> table, @Nonnull String key) throws LuaException {
        Object value = table.get(key);
        if (value instanceof Number) {
            return (int)((Number)value).longValue();
        }
        throw TableHelper.badKey(key, "number", value);
    }

    public static double getRealField(@Nonnull Map<?, ?> table, @Nonnull String key) throws LuaException {
        return TableHelper.checkReal(key, TableHelper.getNumberField(table, key));
    }

    public static boolean getBooleanField(@Nonnull Map<?, ?> table, @Nonnull String key) throws LuaException {
        Object value = table.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw TableHelper.badKey(key, "boolean", value);
    }

    @Nonnull
    public static String getStringField(@Nonnull Map<?, ?> table, @Nonnull String key) throws LuaException {
        Object value = table.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        throw TableHelper.badKey(key, "string", value);
    }

    @Nonnull
    public static Map<Object, Object> getTableField(@Nonnull Map<?, ?> table, @Nonnull String key) throws LuaException {
        Object value = table.get(key);
        if (value instanceof Map) {
            return (Map)value;
        }
        throw TableHelper.badKey(key, "table", value);
    }

    public static double optNumberField(@Nonnull Map<?, ?> table, @Nonnull String key, double def) throws LuaException {
        Object value = table.get(key);
        if (value == null) {
            return def;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw TableHelper.badKey(key, "number", value);
    }

    public static int optIntField(@Nonnull Map<?, ?> table, @Nonnull String key, int def) throws LuaException {
        Object value = table.get(key);
        if (value == null) {
            return def;
        }
        if (value instanceof Number) {
            return (int)((Number)value).longValue();
        }
        throw TableHelper.badKey(key, "number", value);
    }

    public static double optRealField(@Nonnull Map<?, ?> table, @Nonnull String key, double def) throws LuaException {
        return TableHelper.checkReal(key, TableHelper.optNumberField(table, key, def));
    }

    public static boolean optBooleanField(@Nonnull Map<?, ?> table, @Nonnull String key, boolean def) throws LuaException {
        Object value = table.get(key);
        if (value == null) {
            return def;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw TableHelper.badKey(key, "boolean", value);
    }

    public static String optStringField(@Nonnull Map<?, ?> table, @Nonnull String key, String def) throws LuaException {
        Object value = table.get(key);
        if (value == null) {
            return def;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw TableHelper.badKey(key, "string", value);
    }

    public static Map<Object, Object> optTableField(@Nonnull Map<?, ?> table, @Nonnull String key, Map<Object, Object> def) throws LuaException {
        Object value = table.get(key);
        if (value == null) {
            return def;
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw TableHelper.badKey(key, "table", value);
    }

    private static double checkReal(@Nonnull String key, double value) throws LuaException {
        if (!Double.isFinite(value)) {
            throw TableHelper.badKey(key, "number", LuaValues.getNumericType(value));
        }
        return value;
    }
}

