/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http.options;

import dan200.computercraft.core.apis.http.options.Action;
import dan200.computercraft.core.apis.http.options.Options;
import javax.annotation.Nonnull;

public final class PartialOptions {
    static final PartialOptions DEFAULT = new PartialOptions(null, null, null, null, null);
    Action action;
    Long maxUpload;
    Long maxDownload;
    Integer timeout;
    Integer websocketMessage;
    Options options;

    PartialOptions(Action action, Long maxUpload, Long maxDownload, Integer timeout, Integer websocketMessage) {
        this.action = action;
        this.maxUpload = maxUpload;
        this.maxDownload = maxDownload;
        this.timeout = timeout;
        this.websocketMessage = websocketMessage;
    }

    @Nonnull
    Options toOptions() {
        if (this.options != null) {
            return this.options;
        }
        this.options = new Options(this.action == null ? Action.DENY : this.action, this.maxUpload == null ? 0x400000L : this.maxUpload, this.maxDownload == null ? 0x1000000L : this.maxDownload, this.timeout == null ? 30000 : this.timeout, this.websocketMessage == null ? 131072 : this.websocketMessage);
        return this.options;
    }

    void merge(@Nonnull PartialOptions other) {
        if (this.action == null && other.action != null) {
            this.action = other.action;
        }
        if (this.maxUpload == null && other.maxUpload != null) {
            this.maxUpload = other.maxUpload;
        }
        if (this.maxDownload == null && other.maxDownload != null) {
            this.maxDownload = other.maxDownload;
        }
        if (this.timeout == null && other.timeout != null) {
            this.timeout = other.timeout;
        }
        if (this.websocketMessage == null && other.websocketMessage != null) {
            this.websocketMessage = other.websocketMessage;
        }
    }

    PartialOptions copy() {
        return new PartialOptions(this.action, this.maxUpload, this.maxDownload, this.timeout, this.websocketMessage);
    }
}

