/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.util.Colour;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class ItemDisk
extends Item
implements IMedia,
IColouredItem {
    private static final String NBT_ID = "DiskId";

    public ItemDisk(Item.Properties settings) {
        super(settings);
    }

    @Nonnull
    public static ItemStack createFromIDAndColour(int id, String label, int colour) {
        ItemStack stack = new ItemStack((ItemLike)Registry.ModItems.DISK.get());
        ItemDisk.setDiskID(stack, id);
        ((ItemDisk)Registry.ModItems.DISK.get()).setLabel(stack, label);
        IColouredItem.setColourBasic(stack, colour);
        return stack;
    }

    public void m_6787_(@Nonnull CreativeModeTab tabs, @Nonnull NonNullList<ItemStack> list) {
        if (!this.m_41389_(tabs)) {
            return;
        }
        for (int colour = 0; colour < 16; ++colour) {
            list.add((Object)ItemDisk.createFromIDAndColour(-1, null, Colour.VALUES[colour].getHex()));
        }
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> list, TooltipFlag options) {
        int id;
        if (options.m_7050_() && (id = ItemDisk.getDiskID(stack)) >= 0) {
            list.add((Component)new TranslatableComponent("gui.computercraft.tooltip.disk_id", new Object[]{id}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    @Override
    public String getLabel(@Nonnull ItemStack stack) {
        return stack.m_41788_() ? stack.m_41786_().getString() : null;
    }

    @Override
    public boolean setLabel(@Nonnull ItemStack stack, String label) {
        if (label != null) {
            stack.m_41714_((Component)new TextComponent(label));
        } else {
            stack.m_41787_();
        }
        return true;
    }

    @Override
    public IMount createDataMount(@Nonnull ItemStack stack, @Nonnull Level world) {
        int diskID = ItemDisk.getDiskID(stack);
        if (diskID < 0) {
            diskID = ComputerCraftAPI.createUniqueNumberedSaveDir(world, "disk");
            ItemDisk.setDiskID(stack, diskID);
        }
        return ComputerCraftAPI.createSaveDirMount(world, "disk/" + diskID, ComputerCraft.floppySpaceLimit);
    }

    public static int getDiskID(@Nonnull ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_(NBT_ID) ? nbt.m_128451_(NBT_ID) : -1;
    }

    private static void setDiskID(@Nonnull ItemStack stack, int id) {
        if (id >= 0) {
            stack.m_41784_().m_128405_(NBT_ID, id);
        }
    }

    @Override
    public int getColour(@Nonnull ItemStack stack) {
        int colour = IColouredItem.getColourBasic(stack);
        return colour == -1 ? Colour.WHITE.getHex() : colour;
    }
}

