/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.ValueFactory;

public abstract class LuaBaseString
extends LuaValue {
    LuaBaseString() {
        super(4);
    }

    @Override
    public final LuaTable getMetatable(LuaState state) {
        return state.stringMetatable;
    }

    @Override
    public final double checkArith() throws LuaError {
        double d = this.scanNumber(10);
        if (Double.isNaN(d)) {
            throw ErrorFactory.arithError(this);
        }
        return d;
    }

    @Override
    public final int checkInteger() throws LuaError {
        return (int)this.checkDouble();
    }

    @Override
    public final LuaInteger checkLuaInteger() throws LuaError {
        return ValueFactory.valueOf(this.checkInteger());
    }

    @Override
    public final long checkLong() throws LuaError {
        return (long)this.checkDouble();
    }

    @Override
    public final double checkDouble() throws LuaError {
        double d = this.scanNumber(10);
        if (Double.isNaN(d)) {
            throw ErrorFactory.argError(this, "number");
        }
        return d;
    }

    @Override
    public final LuaNumber checkNumber() throws LuaError {
        return ValueFactory.valueOf(this.checkDouble());
    }

    @Override
    public final LuaNumber checkNumber(String msg) throws LuaError {
        double d = this.scanNumber(10);
        if (Double.isNaN(d)) {
            throw new LuaError(msg);
        }
        return ValueFactory.valueOf(d);
    }

    @Override
    public final LuaValue toNumber() {
        return this.tonumber(10);
    }

    @Override
    public final boolean isNumber() {
        double d = this.scanNumber(10);
        return !Double.isNaN(d);
    }

    @Override
    public final boolean isInteger() {
        double d = this.scanNumber(10);
        return !Double.isNaN(d) && (double)((int)d) == d;
    }

    @Override
    public final boolean isLong() {
        double d = this.scanNumber(10);
        return !Double.isNaN(d) && (double)((long)d) == d;
    }

    @Override
    public final double toDouble() {
        return this.scanNumber(10);
    }

    @Override
    public final int toInteger() {
        return (int)this.toLong();
    }

    @Override
    public final long toLong() {
        return (long)this.toDouble();
    }

    @Override
    public final double optDouble(double defval) throws LuaError {
        return this.checkNumber().checkDouble();
    }

    @Override
    public final int optInteger(int defval) throws LuaError {
        return this.checkNumber().checkInteger();
    }

    @Override
    public final LuaInteger optLuaInteger(LuaInteger defval) throws LuaError {
        return this.checkNumber().checkLuaInteger();
    }

    @Override
    public final long optLong(long defval) throws LuaError {
        return this.checkNumber().checkLong();
    }

    @Override
    public final LuaNumber optNumber(LuaNumber defval) throws LuaError {
        return this.checkNumber().checkNumber();
    }

    @Override
    public final LuaString optLuaString(LuaString defval) {
        return this.strvalue();
    }

    @Override
    public final LuaValue toLuaString() {
        return this.strvalue();
    }

    @Override
    public final String optString(String defval) {
        return this.toString();
    }

    @Override
    public abstract LuaString strvalue();

    @Override
    public final String checkString() {
        return this.toString();
    }

    @Override
    public final LuaString checkLuaString() {
        return this.strvalue();
    }

    @Override
    public final LuaBaseString checkLuaBaseString() {
        return this;
    }

    public final LuaValue tonumber(int base) {
        double d = this.scanNumber(base);
        return Double.isNaN(d) ? Constants.NIL : ValueFactory.valueOf(d);
    }

    public abstract int length();

    public abstract double scanNumber(int var1);
}

