/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.debug;

import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.NonResumableException;
import org.squiddev.cobalt.Resumable;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.debug.DebugHelpers;
import org.squiddev.cobalt.function.LuaClosure;
import org.squiddev.cobalt.function.LuaFunction;
import org.squiddev.cobalt.function.LuaInterpreter;
import org.squiddev.cobalt.function.Upvalue;

public final class DebugFrame {
    public static final int FLAG_HOOKED = 4;
    public static final int FLAG_FRESH = 8;
    public static final int FLAG_YPCALL = 16;
    public static final int FLAG_HOOKYIELD = 64;
    public static final int FLAG_LEQ = 128;
    public static final int FLAG_ERROR = 1024;
    public static final int FLAG_HOOKYIELD_LINE = 2048;
    public static final int FLAG_JAVA = 4096;
    public static final int FLAG_TAIL = 8192;
    public LuaFunction func;
    public LuaClosure closure;
    public LuaValue[] stack;
    public Upvalue[] stackUpvalues;
    public Object state;
    public final DebugFrame previous;
    private static final LuaString TEMPORARY = ValueFactory.valueOf("(*temporary)");
    public Varargs varargs;
    public Varargs extras;
    public int pc = -1;
    public int oldPc = -1;
    public int top = -1;
    public int flags;

    public DebugFrame(DebugFrame previous) {
        this.previous = previous;
        this.func = null;
    }

    public DebugFrame(LuaFunction func) {
        this.previous = null;
        this.func = func;
        this.closure = func instanceof LuaClosure ? (LuaClosure)func : null;
    }

    public void setFunction(LuaClosure closure, Varargs varargs, LuaValue[] stack, Upvalue[] stackUpvalues) {
        this.func = closure;
        this.closure = closure;
        this.varargs = varargs;
        this.stack = stack;
        this.stackUpvalues = stackUpvalues;
    }

    public <S, T extends LuaFunction> void setFunction(T func, S state) {
        this.func = func;
        this.closure = func instanceof LuaClosure ? (LuaClosure)func : null;
        this.state = state;
    }

    public void cleanup() {
        LuaInterpreter.closeAll(this.stackUpvalues);
    }

    void clear() {
        this.func = null;
        this.closure = null;
        this.stack = null;
        this.stackUpvalues = null;
        this.state = null;
        this.extras = null;
        this.varargs = null;
        this.flags = 0;
        this.top = -1;
        this.pc = -1;
        this.oldPc = -1;
    }

    public int currentLine() {
        if (this.closure == null) {
            return -1;
        }
        int[] li = this.closure.getPrototype().lineinfo;
        return li == null || this.pc < 0 || this.pc >= li.length ? -1 : li[this.pc];
    }

    public LuaString[] getFuncKind() {
        DebugFrame previous = this.previous;
        if ((this.flags & 0x2000) != 0) {
            return null;
        }
        if (previous == null || previous.closure == null || previous.pc < 0) {
            return null;
        }
        int stackpos = previous.closure.getPrototype().code[previous.pc] >> 6 & 0xFF;
        return DebugHelpers.getFuncName(previous, stackpos);
    }

    public String sourceLine() {
        if (this.closure == null) {
            return this.func == null ? "nil" : this.func.debugName();
        }
        return this.closure.getPrototype().sourceShort() + ":" + this.currentLine();
    }

    public LuaString getLocalName(int index) {
        if (this.closure == null) {
            return null;
        }
        LuaString name = this.closure.getPrototype().getlocalname(index, this.pc);
        if (name != null) {
            return name;
        }
        return index > 0 && index <= this.closure.getPrototype().maxstacksize ? TEMPORARY : null;
    }

    public Varargs resume(LuaState state, Varargs args) throws LuaError, UnwindThrowable {
        if (this.func instanceof Resumable) {
            return ((Resumable)((Object)this.func)).resume(state, this.state, args);
        }
        throw new NonResumableException(this.func == null ? "null" : this.func.debugName());
    }

    public Varargs resumeError(LuaState state, LuaError error) throws LuaError, UnwindThrowable {
        if (this.func instanceof Resumable) {
            return ((Resumable)((Object)this.func)).resumeError(state, this.state, error);
        }
        throw new NonResumableException(this.func == null ? "null" : this.func.debugName());
    }
}

