/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderUtil;
import com.supermartijn642.core.block.BaseTileEntity;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ChunkLoaderTile
extends BaseTileEntity {
    public final int animationOffset = new Random().nextInt(20000);
    private int gridSize;
    private int radius;
    private boolean[][] grid;
    private boolean dataChanged = false;

    public ChunkLoaderTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state, int gridSize) {
        super(tileEntityTypeIn, pos, state);
        this.gridSize = gridSize;
        this.radius = (gridSize - 1) / 2;
        this.grid = new boolean[gridSize][gridSize];
    }

    public void unloadAll() {
        this.f_58857_.getCapability(ChunkLoaderUtil.TRACKER_CAPABILITY).ifPresent(tracker -> {
            ChunkPos pos = this.f_58857_.m_46865_(this.f_58858_).m_7697_();
            for (int x = 0; x < this.gridSize; ++x) {
                for (int z = 0; z < this.gridSize; ++z) {
                    if (!this.grid[x][z]) continue;
                    tracker.remove(new ChunkPos(pos.f_45578_ + x - this.radius, pos.f_45579_ + z - this.radius), this.f_58858_);
                }
            }
        });
    }

    public void loadAll() {
        this.f_58857_.getCapability(ChunkLoaderUtil.TRACKER_CAPABILITY).ifPresent(tracker -> {
            ChunkPos pos = this.f_58857_.m_46865_(this.f_58858_).m_7697_();
            for (int x = 0; x < this.gridSize; ++x) {
                for (int z = 0; z < this.gridSize; ++z) {
                    this.grid[x][z] = true;
                    tracker.add(new ChunkPos(pos.f_45578_ + x - this.radius, pos.f_45579_ + z - this.radius), this.f_58858_);
                }
            }
        });
        this.dataChanged();
    }

    public void toggle(int xOffset, int zOffset) {
        this.f_58857_.getCapability(ChunkLoaderUtil.TRACKER_CAPABILITY).ifPresent(tracker -> {
            ChunkPos pos = this.f_58857_.m_46865_(this.f_58858_).m_7697_();
            if (this.grid[xOffset + this.radius][zOffset + this.radius]) {
                tracker.remove(new ChunkPos(pos.f_45578_ + xOffset, pos.f_45579_ + zOffset), this.f_58858_);
            } else {
                tracker.add(new ChunkPos(pos.f_45578_ + xOffset, pos.f_45579_ + zOffset), this.f_58858_);
            }
            this.grid[xOffset + this.radius][zOffset + this.radius] = !this.grid[xOffset + this.radius][zOffset + this.radius];
        });
        this.dataChanged();
    }

    public boolean isLoaded(int xOffset, int zOffset) {
        return this.grid[xOffset + this.radius][zOffset + this.radius];
    }

    public int getGridSize() {
        return this.gridSize;
    }

    protected CompoundTag writeData() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("gridSize", this.gridSize);
        for (int x = 0; x < this.gridSize; ++x) {
            for (int z = 0; z < this.gridSize; ++z) {
                tag.m_128379_(x + ";" + z, this.grid[x][z]);
            }
        }
        return tag;
    }

    protected void readData(CompoundTag tag) {
        int n = this.gridSize = tag.m_128441_("gridSize") ? tag.m_128451_("gridSize") : this.gridSize;
        if (this.gridSize < 1 || this.gridSize % 2 == 0) {
            this.gridSize = 1;
        }
        this.radius = (this.gridSize - 1) / 2;
        this.grid = new boolean[this.gridSize][this.gridSize];
        for (int x = 0; x < this.gridSize; ++x) {
            for (int z = 0; z < this.gridSize; ++z) {
                this.grid[x][z] = tag.m_128441_(x + ";" + z) && tag.m_128471_(x + ";" + z);
            }
        }
    }
}

