/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.google.common.collect.Lists;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.model.ProxyBuilderModel;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Vector3f;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.io.IOUtils;

public final class BasicDrawerModel {
    private static final Map<Direction, BakedModel> lockOverlaysFull = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> lockOverlaysHalf = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> voidOverlaysFull = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> voidOverlaysHalf = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> shroudOverlaysFull = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> shroudOverlaysHalf = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> indicator1Full = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> indicator1Half = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> indicator2Full = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> indicator2Half = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> indicator4Full = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> indicator4Half = new HashMap<Direction, BakedModel>();
    private static final Map<Direction, BakedModel> indicatorComp = new HashMap<Direction, BakedModel>();
    private static boolean geometryDataLoaded = false;

    public static class Model
    extends ProxyBuilderModel {
        Direction side;
        Map<Direction, BakedModel> overlays;

        public Model(BakedModel parent, Map<Direction, BakedModel> overlays, Direction side) {
            super(parent);
            this.overlays = overlays;
            this.side = side;
        }

        @Override
        protected BakedModel buildModel(BlockState state, BakedModel parent) {
            return new MergedModel(parent, this.overlays.get(this.side));
        }
    }

    public static abstract class Model2
    implements IDynamicBakedModel {
        protected final BakedModel mainModel;
        protected final Map<Direction, BakedModel> lockOverlay;
        protected final Map<Direction, BakedModel> voidOverlay;
        protected final Map<Direction, BakedModel> shroudOverlay;
        protected final Map<Direction, BakedModel> indicator1Overlay;
        protected final Map<Direction, BakedModel> indicator2Overlay;
        protected final Map<Direction, BakedModel> indicator4Overlay;
        protected final Map<Direction, BakedModel> indicatorCompOverlay;

        private Model2(BakedModel mainModel, Map<Direction, BakedModel> lockOverlay, Map<Direction, BakedModel> voidOverlay, Map<Direction, BakedModel> shroudOverlay, Map<Direction, BakedModel> indicator1Overlay, Map<Direction, BakedModel> indicator2Overlay, Map<Direction, BakedModel> indicator4Overlay) {
            this.mainModel = mainModel;
            this.lockOverlay = lockOverlay;
            this.voidOverlay = voidOverlay;
            this.shroudOverlay = shroudOverlay;
            this.indicator1Overlay = indicator1Overlay;
            this.indicator2Overlay = indicator2Overlay;
            this.indicator4Overlay = indicator4Overlay;
            this.indicatorCompOverlay = indicatorComp;
        }

        public boolean m_7547_() {
            return this.mainModel.m_7547_();
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            ArrayList quads = Lists.newArrayList();
            quads.addAll(this.mainModel.getQuads(state, side, rand, extraData));
            if (state != null && extraData.hasProperty(TileEntityDrawers.ATTRIBUTES)) {
                IDrawerAttributes attr = (IDrawerAttributes)extraData.getData(TileEntityDrawers.ATTRIBUTES);
                Direction dir = (Direction)state.m_61143_((Property)BlockDrawers.f_54117_);
                if (attr.isItemLocked(LockAttribute.LOCK_EMPTY) || attr.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                    quads.addAll(this.lockOverlay.get(dir).getQuads(state, side, rand, extraData));
                }
                if (attr.isVoid()) {
                    quads.addAll(this.voidOverlay.get(dir).getQuads(state, side, rand, extraData));
                }
                if (attr.isConcealed()) {
                    quads.addAll(this.shroudOverlay.get(dir).getQuads(state, side, rand, extraData));
                }
                if (attr.hasFillLevel()) {
                    Block block = state.m_60734_();
                    if (block instanceof BlockCompDrawers) {
                        quads.addAll(this.indicatorCompOverlay.get(dir).getQuads(state, side, rand, extraData));
                    } else if (block instanceof BlockDrawers) {
                        int count = ((BlockDrawers)block).getDrawerCount();
                        if (count == 1) {
                            quads.addAll(this.indicator1Overlay.get(dir).getQuads(state, side, rand, extraData));
                        } else if (count == 2) {
                            quads.addAll(this.indicator2Overlay.get(dir).getQuads(state, side, rand, extraData));
                        } else if (count == 4) {
                            quads.addAll(this.indicator4Overlay.get(dir).getQuads(state, side, rand, extraData));
                        }
                    }
                }
            }
            return quads;
        }

        public boolean m_7541_() {
            return this.mainModel.m_7541_();
        }

        public boolean m_7539_() {
            return this.mainModel.m_7539_();
        }

        public boolean m_7521_() {
            return this.mainModel.m_7521_();
        }

        public TextureAtlasSprite m_6160_() {
            return this.mainModel.m_6160_();
        }

        public ItemOverrides m_7343_() {
            return this.mainModel.m_7343_();
        }

        public static class HalfModel
        extends Model2 {
            HalfModel(BakedModel mainModel) {
                super(mainModel, lockOverlaysHalf, voidOverlaysHalf, shroudOverlaysHalf, indicator1Half, indicator2Half, indicator4Half);
            }
        }

        public static class FullModel
        extends Model2 {
            FullModel(BakedModel mainModel) {
                super(mainModel, lockOverlaysFull, voidOverlaysFull, shroudOverlaysFull, indicator1Full, indicator2Full, indicator4Full);
            }
        }
    }

    public static class MergedModel
    implements BakedModel {
        protected final BakedModel mainModel;
        protected final BakedModel[] models;

        public MergedModel(BakedModel mainModel, BakedModel ... models) {
            this.mainModel = mainModel;
            this.models = models;
        }

        public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            ArrayList quads = Lists.newArrayList();
            quads.addAll(this.mainModel.m_6840_(state, side, rand));
            for (BakedModel model : this.models) {
                quads.addAll(model.m_6840_(state, side, rand));
            }
            return quads;
        }

        public boolean m_7541_() {
            return this.mainModel.m_7541_();
        }

        public boolean m_7539_() {
            return this.mainModel.m_7539_();
        }

        public boolean m_7547_() {
            return this.mainModel.m_7547_();
        }

        public boolean m_7521_() {
            return this.mainModel.m_7521_();
        }

        public TextureAtlasSprite m_6160_() {
            return this.mainModel.m_6160_();
        }

        public ItemOverrides m_7343_() {
            return this.mainModel.m_7343_();
        }
    }

    @Mod.EventBusSubscriber(modid="storagedrawers", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Register {
        @SubscribeEvent
        public static void registerTextures(TextureStitchEvent.Pre event) {
            if (ModBlocks.OAK_FULL_DRAWERS_1 == null) {
                StorageDrawers.log.warn("Block objects not set in TextureStitchEvent.  Is your mod environment broken?");
                return;
            }
            Register.loadUnbakedModel(event, new ResourceLocation("storagedrawers", "models/block/full_drawers_lock.json"));
            Register.loadUnbakedModel(event, new ResourceLocation("storagedrawers", "models/block/full_drawers_void.json"));
            Register.loadUnbakedModel(event, new ResourceLocation("storagedrawers", "models/block/full_drawers_shroud.json"));
            Register.loadUnbakedModel(event, new ResourceLocation("storagedrawers", "models/block/compdrawers_indicator.json"));
            Register.loadUnbakedModel(event, new ResourceLocation("storagedrawers", "models/block/full_drawers_indicator_1.json"));
            Register.loadUnbakedModel(event, new ResourceLocation("storagedrawers", "models/block/full_drawers_indicator_2.json"));
            Register.loadUnbakedModel(event, new ResourceLocation("storagedrawers", "models/block/full_drawers_indicator_4.json"));
            Register.loadGeometryData();
        }

        private static void loadUnbakedModel(TextureStitchEvent.Pre event, ResourceLocation resource) {
            BlockModel unbakedModel = Register.getBlockModel(resource);
            for (Either x : unbakedModel.f_111417_.values()) {
                x.ifLeft(value -> {
                    if (value.m_119193_().equals((Object)event.getAtlas().m_118330_())) {
                        event.addSprite(value.m_119203_());
                    }
                });
            }
        }

        private static void loadGeometryData() {
            if (geometryDataLoaded) {
                return;
            }
            geometryDataLoaded = true;
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_icon_area_1.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_count_area_1.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_ind_area_1.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_indbase_area_1.json"), ModBlocks.OAK_FULL_DRAWERS_1, ModBlocks.SPRUCE_FULL_DRAWERS_1, ModBlocks.BIRCH_FULL_DRAWERS_1, ModBlocks.JUNGLE_FULL_DRAWERS_1, ModBlocks.ACACIA_FULL_DRAWERS_1, ModBlocks.DARK_OAK_FULL_DRAWERS_1, ModBlocks.CRIMSON_FULL_DRAWERS_1, ModBlocks.WARPED_FULL_DRAWERS_1);
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_icon_area_2.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_count_area_2.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_ind_area_2.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_indbase_area_2.json"), ModBlocks.OAK_FULL_DRAWERS_2, ModBlocks.SPRUCE_FULL_DRAWERS_2, ModBlocks.BIRCH_FULL_DRAWERS_2, ModBlocks.JUNGLE_FULL_DRAWERS_2, ModBlocks.ACACIA_FULL_DRAWERS_2, ModBlocks.DARK_OAK_FULL_DRAWERS_2, ModBlocks.CRIMSON_FULL_DRAWERS_2, ModBlocks.WARPED_FULL_DRAWERS_2);
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_icon_area_4.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_count_area_4.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_ind_area_4.json"), new ResourceLocation("storagedrawers", "models/block/geometry/full_drawers_indbase_area_4.json"), ModBlocks.OAK_FULL_DRAWERS_4, ModBlocks.SPRUCE_FULL_DRAWERS_4, ModBlocks.BIRCH_FULL_DRAWERS_4, ModBlocks.JUNGLE_FULL_DRAWERS_4, ModBlocks.ACACIA_FULL_DRAWERS_4, ModBlocks.DARK_OAK_FULL_DRAWERS_4, ModBlocks.CRIMSON_FULL_DRAWERS_4, ModBlocks.WARPED_FULL_DRAWERS_4);
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_icon_area_1.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_count_area_1.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_ind_area_1.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_indbase_area_1.json"), ModBlocks.OAK_HALF_DRAWERS_1, ModBlocks.SPRUCE_HALF_DRAWERS_1, ModBlocks.BIRCH_HALF_DRAWERS_1, ModBlocks.JUNGLE_HALF_DRAWERS_1, ModBlocks.ACACIA_HALF_DRAWERS_1, ModBlocks.DARK_OAK_HALF_DRAWERS_1, ModBlocks.CRIMSON_HALF_DRAWERS_1, ModBlocks.WARPED_HALF_DRAWERS_1);
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_icon_area_2.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_count_area_2.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_ind_area_2.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_indbase_area_2.json"), ModBlocks.OAK_HALF_DRAWERS_2, ModBlocks.SPRUCE_HALF_DRAWERS_2, ModBlocks.BIRCH_HALF_DRAWERS_2, ModBlocks.JUNGLE_HALF_DRAWERS_2, ModBlocks.ACACIA_HALF_DRAWERS_2, ModBlocks.DARK_OAK_HALF_DRAWERS_2, ModBlocks.CRIMSON_HALF_DRAWERS_2, ModBlocks.WARPED_HALF_DRAWERS_2);
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_icon_area_4.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_count_area_4.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_ind_area_4.json"), new ResourceLocation("storagedrawers", "models/block/geometry/half_drawers_indbase_area_4.json"), ModBlocks.OAK_HALF_DRAWERS_4, ModBlocks.SPRUCE_HALF_DRAWERS_4, ModBlocks.BIRCH_HALF_DRAWERS_4, ModBlocks.JUNGLE_HALF_DRAWERS_4, ModBlocks.ACACIA_HALF_DRAWERS_4, ModBlocks.DARK_OAK_HALF_DRAWERS_4, ModBlocks.CRIMSON_HALF_DRAWERS_4, ModBlocks.WARPED_HALF_DRAWERS_4);
            Register.populateGeometryData(new ResourceLocation("storagedrawers", "models/block/geometry/comp_drawers_icon_area_3.json"), new ResourceLocation("storagedrawers", "models/block/geometry/comp_drawers_count_area_3.json"), new ResourceLocation("storagedrawers", "models/block/geometry/comp_drawers_ind_area_3.json"), new ResourceLocation("storagedrawers", "models/block/geometry/comp_drawers_indbase_area_3.json"), ModBlocks.COMPACTING_DRAWERS_3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static BlockModel getBlockModel(ResourceLocation location) {
            BlockModel blockModel;
            Resource iresource = null;
            InputStreamReader reader = null;
            try {
                iresource = Minecraft.m_91087_().m_91098_().m_142591_(location);
                reader = new InputStreamReader(iresource.m_6679_(), StandardCharsets.UTF_8);
                blockModel = BlockModel.m_111461_((Reader)reader);
                IOUtils.closeQuietly((Reader)reader);
            }
            catch (IOException e) {
                BlockModel blockModel2 = null;
                return blockModel2;
            }
            finally {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly((Closeable)iresource);
            }
            IOUtils.closeQuietly((Closeable)iresource);
            return blockModel;
        }

        private static void populateGeometryData(ResourceLocation locationIcon, ResourceLocation locationCount, ResourceLocation locationInd, ResourceLocation locationIndBase, BlockDrawers ... blocks) {
            BlockModel slotInfo = Register.getBlockModel(locationIcon);
            BlockModel countInfo = Register.getBlockModel(locationCount);
            BlockModel indInfo = Register.getBlockModel(locationInd);
            BlockModel indBaseInfo = Register.getBlockModel(locationIndBase);
            for (BlockDrawers block : blocks) {
                Vector3f to;
                Vector3f from;
                int i;
                if (block == null) continue;
                for (i = 0; i < block.getDrawerCount(); ++i) {
                    from = ((BlockElement)slotInfo.m_111436_().get((int)i)).f_111308_;
                    to = ((BlockElement)slotInfo.m_111436_().get((int)i)).f_111309_;
                    block.labelGeometry[i] = new AABB((double)from.m_122239_(), (double)from.m_122260_(), (double)from.m_122269_(), (double)to.m_122239_(), (double)to.m_122260_(), (double)to.m_122269_());
                }
                for (i = 0; i < block.getDrawerCount(); ++i) {
                    from = ((BlockElement)countInfo.m_111436_().get((int)i)).f_111308_;
                    to = ((BlockElement)countInfo.m_111436_().get((int)i)).f_111309_;
                    block.countGeometry[i] = new AABB((double)from.m_122239_(), (double)from.m_122260_(), (double)from.m_122269_(), (double)to.m_122239_(), (double)to.m_122260_(), (double)to.m_122269_());
                }
                for (i = 0; i < block.getDrawerCount(); ++i) {
                    from = ((BlockElement)indInfo.m_111436_().get((int)i)).f_111308_;
                    to = ((BlockElement)indInfo.m_111436_().get((int)i)).f_111309_;
                    block.indGeometry[i] = new AABB((double)from.m_122239_(), (double)from.m_122260_(), (double)from.m_122269_(), (double)to.m_122239_(), (double)to.m_122260_(), (double)to.m_122269_());
                }
                for (i = 0; i < block.getDrawerCount(); ++i) {
                    from = ((BlockElement)indBaseInfo.m_111436_().get((int)i)).f_111308_;
                    to = ((BlockElement)indBaseInfo.m_111436_().get((int)i)).f_111309_;
                    block.indBaseGeometry[i] = new AABB((double)from.m_122239_(), (double)from.m_122260_(), (double)from.m_122269_(), (double)to.m_122239_(), (double)to.m_122260_(), (double)to.m_122269_());
                }
            }
        }

        @SubscribeEvent
        public static void registerModels(ModelBakeEvent event) {
            if (ModBlocks.OAK_FULL_DRAWERS_1 == null) {
                StorageDrawers.log.warn("Block objects not set in ModelBakeEvent.  Is your mod environment broken?");
                return;
            }
            for (int i = 0; i < 4; ++i) {
                Direction dir = Direction.m_122407_((int)i);
                BlockModelRotation rot = BlockModelRotation.m_119153_((int)0, (int)((int)dir.m_122435_() + 180));
                Function texGet = ForgeModelBakery.defaultTextureGetter();
                lockOverlaysFull.put(dir, event.getModelLoader().bake(new ResourceLocation("storagedrawers", "block/full_drawers_lock"), (ModelState)rot, texGet));
                lockOverlaysHalf.put(dir, event.getModelLoader().bake(new ResourceLocation("storagedrawers", "block/half_drawers_lock"), (ModelState)rot, texGet));
                voidOverlaysFull.put(dir, event.getModelLoader().bake(new ResourceLocation("storagedrawers", "block/full_drawers_void"), (ModelState)rot, texGet));
                voidOverlaysHalf.put(dir, event.getModelLoader().bake(new ResourceLocation("storagedrawers", "block/half_drawers_void"), (ModelState)rot, texGet));
                shroudOverlaysFull.put(dir, event.getModelLoader().bake(new ResourceLocation("storagedrawers", "block/full_drawers_shroud"), (ModelState)rot, texGet));
                shroudOverlaysHalf.put(dir, event.getModelLoader().bake(new ResourceLocation("storagedrawers", "block/half_drawers_shroud"), (ModelState)rot, texGet));
                indicator1Full.put(dir, event.getModelLoader().bake(new ResourceLocation("storagedrawers", "block/full_drawers_indicator_1"), (ModelState)rot, texGet));
                indicator1Half.put(dir, event.getModelLoader().bake(new ResourceLocation("storagedrawers", "block/half_drawers_indicator_1"), (ModelState)rot, texGet));
                indicator2Full.put(dir, event.getModelLoader().bake(new ResourceLocation("storagedrawers", "block/full_drawers_indicator_2"), (ModelState)rot, texGet));
                indicator2Half.put(dir, event.getModelLoader().bake(new ResourceLocation("storagedrawers", "block/half_drawers_indicator_2"), (ModelState)rot, texGet));
                indicator4Full.put(dir, event.getModelLoader().bake(new ResourceLocation("storagedrawers", "block/full_drawers_indicator_4"), (ModelState)rot, texGet));
                indicator4Half.put(dir, event.getModelLoader().bake(new ResourceLocation("storagedrawers", "block/half_drawers_indicator_4"), (ModelState)rot, texGet));
                indicatorComp.put(dir, event.getModelLoader().bake(new ResourceLocation("storagedrawers", "block/compdrawers_indicator"), (ModelState)rot, texGet));
            }
            Register.replaceBlock(event, ModBlocks.OAK_FULL_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.OAK_FULL_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.OAK_FULL_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.OAK_HALF_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.OAK_HALF_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.OAK_HALF_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.SPRUCE_FULL_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.SPRUCE_FULL_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.SPRUCE_FULL_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.SPRUCE_HALF_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.SPRUCE_HALF_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.SPRUCE_HALF_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.BIRCH_FULL_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.BIRCH_FULL_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.BIRCH_FULL_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.BIRCH_HALF_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.BIRCH_HALF_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.BIRCH_HALF_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.JUNGLE_FULL_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.JUNGLE_FULL_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.JUNGLE_FULL_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.JUNGLE_HALF_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.JUNGLE_HALF_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.JUNGLE_HALF_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.ACACIA_FULL_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.ACACIA_FULL_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.ACACIA_FULL_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.ACACIA_HALF_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.ACACIA_HALF_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.ACACIA_HALF_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.DARK_OAK_FULL_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.DARK_OAK_FULL_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.DARK_OAK_FULL_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.DARK_OAK_HALF_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.DARK_OAK_HALF_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.DARK_OAK_HALF_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.CRIMSON_FULL_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.CRIMSON_FULL_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.CRIMSON_FULL_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.CRIMSON_HALF_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.CRIMSON_HALF_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.CRIMSON_HALF_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.WARPED_FULL_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.WARPED_FULL_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.WARPED_FULL_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.WARPED_HALF_DRAWERS_1);
            Register.replaceBlock(event, ModBlocks.WARPED_HALF_DRAWERS_2);
            Register.replaceBlock(event, ModBlocks.WARPED_HALF_DRAWERS_4);
            Register.replaceBlock(event, ModBlocks.COMPACTING_DRAWERS_3);
        }

        public static void replaceBlock(ModelBakeEvent event, BlockDrawers block) {
            for (BlockState state : block.m_49965_().m_61056_()) {
                ModelResourceLocation modelResource = BlockModelShaper.m_110895_((BlockState)state);
                BakedModel parentModel = event.getModelManager().m_119422_(modelResource);
                if (parentModel == null) {
                    StorageDrawers.log.warn("Got back null model from ModelBakeEvent.ModelManager for resource " + modelResource.toString());
                    continue;
                }
                if (parentModel == event.getModelManager().m_119409_()) continue;
                if (block.isHalfDepth()) {
                    event.getModelRegistry().put(modelResource, new Model2.HalfModel(parentModel));
                    continue;
                }
                event.getModelRegistry().put(modelResource, new Model2.FullModel(parentModel));
            }
        }
    }
}

