/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.capabilities.CapabilityDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;

public class DrawerOverlay {
    public boolean showContent = true;
    public boolean showStackLimit = true;
    public boolean showStatus = true;
    public boolean showStackRemainder;
    public boolean respectQuantifyKey;

    public DrawerOverlay() {
        this.showStackRemainder = (Boolean)CommonConfig.INTEGRATION.wailaStackRemainder.get();
        this.respectQuantifyKey = (Boolean)CommonConfig.INTEGRATION.wailaRespectQuantifyKey.get();
    }

    public List<Component> getOverlay(TileEntityDrawers tile) {
        ArrayList<Component> result = new ArrayList<Component>();
        IDrawerAttributes attr = (IDrawerAttributes)tile.getCapability(CapabilityDrawerAttributes.DRAWER_ATTRIBUTES_CAPABILITY, null).orElse((Object)EmptyDrawerAttributes.EMPTY);
        this.addContent(result, tile, attr);
        this.addStackLimit(result, tile, attr);
        this.addStatus(result, tile, attr);
        return result;
    }

    private void addContent(List<Component> result, TileEntityDrawers tile, IDrawerAttributes attr) {
        if (!this.showContent || attr.isConcealed()) {
            return;
        }
        boolean showCounts = !this.respectQuantifyKey || attr.isShowingQuantity();
        IDrawerGroup group = tile.getGroup();
        for (int i = 0; i < group.getDrawerCount(); ++i) {
            IDrawer drawer = group.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            TranslatableComponent name = new TranslatableComponent("tooltip.storagedrawers.waila.empty");
            ItemStack stack = drawer.getStoredItemPrototype();
            if (!stack.m_41619_()) {
                MutableComponent stackName = new TranslatableComponent("").m_7220_(stack.m_41611_());
                if (showCounts) {
                    if (drawer.getStoredItemCount() == Integer.MAX_VALUE) {
                        name = stackName.m_130946_("[\u221e]");
                    } else if (drawer instanceof IFractionalDrawer && ((IFractionalDrawer)drawer).getConversionRate() > 1) {
                        String text = (i == 0 ? " [" : " [+") + ((IFractionalDrawer)drawer).getStoredItemRemainder() + "]";
                        name = stackName.m_130946_(text);
                    } else if (this.showStackRemainder) {
                        int stacks = drawer.getStoredItemCount() / drawer.getStoredItemStackSize();
                        int remainder = drawer.getStoredItemCount() - stacks * drawer.getStoredItemStackSize();
                        name = stacks > 0 && remainder > 0 ? stackName.m_130946_(" [" + stacks + "x" + drawer.getStoredItemStackSize() + " + " + remainder + "]") : (stacks > 0 ? stackName.m_130946_(" [" + stacks + "x" + drawer.getStoredItemStackSize() + "]") : stackName.m_130946_(" [" + remainder + "]"));
                    } else {
                        name = stackName.m_130946_(" [" + drawer.getStoredItemCount() + "]");
                    }
                } else {
                    name = stackName;
                }
            }
            result.add((Component)new TranslatableComponent("tooltip.storagedrawers.waila.drawer", new Object[]{i + 1, name}));
        }
    }

    private void addStackLimit(List<Component> result, TileEntityDrawers tile, IDrawerAttributes attr) {
        if (!this.showStackLimit) {
            return;
        }
        if (attr.isUnlimitedStorage() || tile.getDrawerAttributes().isUnlimitedVending()) {
            result.add((Component)new TranslatableComponent("tooltip.storagedrawers.waila.nolimit"));
        } else {
            int multiplier = tile.upgrades().getStorageMultiplier();
            int limit = tile.getEffectiveDrawerCapacity() * multiplier;
            result.add((Component)new TranslatableComponent("tooltip.storagedrawers.waila.limit", new Object[]{limit, multiplier}));
        }
    }

    private void addStatus(List<Component> result, TileEntityDrawers tile, IDrawerAttributes attr) {
        if (!this.showStatus) {
            return;
        }
        ArrayList<TranslatableComponent> attribs = new ArrayList<TranslatableComponent>();
        if (attr.isItemLocked(LockAttribute.LOCK_POPULATED)) {
            attribs.add(new TranslatableComponent("tooltip.storagedrawers.waila.locked"));
        }
        if (attr.isVoid()) {
            attribs.add(new TranslatableComponent("tooltip.storagedrawers.waila.void"));
        }
        if (!attribs.isEmpty()) {
            result.add((Component)attribs.stream().reduce((a, b) -> a.m_7220_((Component)new TextComponent(", ")).m_7220_((Component)b)).get());
        }
    }
}

