/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.SkullRendererCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CustomHeadLayer.class})
public class CustomHeadLayerMixin<T extends LivingEntity, M extends EntityModel<T>> {
    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo info) {
        if (!SkinLayersModBase.config.enableSkulls) {
            return;
        }
        if (livingEntity.m_20280_((Entity)Minecraft.m_91087_().f_91074_) > (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            return;
        }
        ItemStack itemStack = livingEntity.m_6844_(EquipmentSlot.HEAD);
        if (itemStack.m_41619_()) {
            return;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem && ((BlockItem)item).m_40614_() instanceof AbstractSkullBlock) {
            CompoundTag compoundTag;
            GameProfile gameProfile = null;
            if (itemStack.m_41782_() && (compoundTag = itemStack.m_41783_()).m_128425_("SkullOwner", 10)) {
                gameProfile = NbtUtils.m_129228_((CompoundTag)compoundTag.m_128469_("SkullOwner"));
            }
            if (gameProfile != null) {
                SkullRendererCache.lastSkull = SkullRendererCache.itemCache.computeIfAbsent(itemStack, it -> new SkullRendererCache.ItemSettings());
                if (SkullRendererCache.lastSkull.getHeadLayers() == null) {
                    SkinUtil.setup3dLayers(gameProfile, SkullRendererCache.lastSkull);
                }
                SkullRendererCache.renderNext = SkullRendererCache.lastSkull.getHeadLayers() != null;
            }
        }
    }
}

