/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.env.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import team.creative.creativecore.common.util.mc.MaterialUtils;

public class AmbientBlockGroup {
    public List<TagKey<Block>> tags = new ArrayList<TagKey<Block>>();
    public List<Block> blocks = new ArrayList<Block>();
    public List<Material> materials = new ArrayList<Material>();
    public List<String> data = new ArrayList<String>();

    public void onClientLoad() {
        this.tags.clear();
        this.blocks.clear();
        this.materials.clear();
        for (int i = 0; i < this.data.size(); ++i) {
            String entry = this.data.get(i);
            if (entry.startsWith("t->")) {
                TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(entry.replace("t->", "")));
                if (tag == null) continue;
                this.tags.add((TagKey<Block>)tag);
                continue;
            }
            if (entry.startsWith("m->")) {
                Material material = MaterialUtils.getMaterial((String)entry.replace("m->", ""));
                if (material == null) continue;
                this.materials.add(material);
                continue;
            }
            Block block = (Block)Registry.f_122824_.m_7745_(new ResourceLocation(entry));
            if (block == null) continue;
            this.blocks.add(block);
        }
    }

    public void add(String[] data) {
        this.data.addAll(Arrays.asList(data));
    }

    public boolean isEmpty() {
        return this.blocks.isEmpty() && this.tags.isEmpty();
    }

    public boolean is(BlockState state) {
        if (!this.blocks.isEmpty()) {
            for (Block block : this.blocks) {
                if (!state.m_60713_(block)) continue;
                return true;
            }
        }
        if (!this.tags.isEmpty()) {
            for (TagKey tagKey : this.tags) {
                if (!state.m_204336_(tagKey)) continue;
                return true;
            }
        }
        if (!this.materials.isEmpty()) {
            for (Material material : this.materials) {
                if (state.m_60767_() != material) continue;
                return true;
            }
        }
        return false;
    }
}

