/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.hands;

import dev.tr7zw.notenoughanimations.NEAnimationsLoader;
import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.animations.BasicAnimation;
import dev.tr7zw.notenoughanimations.animations.BodyPart;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class HugAnimation
extends BasicAnimation {
    private final BodyPart[] arms = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.RIGHT_ARM};

    @Override
    public boolean isEnabled() {
        return NEAnimationsLoader.config.huggingAnimation;
    }

    @Override
    public boolean isValid(AbstractClientPlayer entity, PlayerData data) {
        AABB aABB;
        if (!entity.m_6047_()) {
            return false;
        }
        double d = 1.0;
        Vec3 vec3 = entity.m_20299_(0.0f);
        Vec3 vec32 = entity.m_20252_(1.0f);
        Vec3 vec33 = vec3.m_82520_(vec32.f_82479_ * d, vec32.f_82480_ * d, vec32.f_82481_ * d);
        EntityHitResult entHit = ProjectileUtil.m_37287_((Entity)entity, (Vec3)vec3, (Vec3)vec33, (AABB)(aABB = entity.m_142469_().m_82369_(vec32.m_82490_(d)).m_82377_(1.0, 1.0, 1.0)), en -> !en.m_5833_(), (double)d);
        if (entHit != null && entHit.m_82443_().m_6095_() == EntityType.f_20532_) {
            AbstractClientPlayer otherPlayer = (AbstractClientPlayer)entHit.m_82443_();
            double dif = otherPlayer.m_20186_() - entity.m_20186_();
            if (otherPlayer.m_6047_() && Math.abs(dif) < 0.3) {
                return true;
            }
        }
        return false;
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayer entity, PlayerData data) {
        return this.arms;
    }

    @Override
    public int getPriority(AbstractClientPlayer entity, PlayerData data) {
        return 2100;
    }

    @Override
    public void apply(AbstractClientPlayer entity, PlayerData data, PlayerModel<AbstractClientPlayer> model, BodyPart part, float delta, float tickCounter) {
        if (part == BodyPart.LEFT_ARM) {
            AnimationUtil.applyArmTransforms(model, HumanoidArm.LEFT, -1.0f, -0.2f, 0.3f);
        }
        if (part == BodyPart.RIGHT_ARM) {
            AnimationUtil.applyArmTransforms(model, HumanoidArm.RIGHT, -1.5f, -0.2f, 0.3f);
        }
    }
}

