/*
 * Decompiled with CFR 0.152.
 */
package frankv.jmi;

import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import frankv.jmi.JMI;
import frankv.jmi.JMIForgeEventListener;
import frankv.jmi.JMIOverlayHelper;
import frankv.jmi.ftbchunks.client.ClaimedChunkPolygon;
import frankv.jmi.ftbchunks.client.ClaimingMode;
import frankv.jmi.ftbchunks.client.ClaimingModeHandler;
import frankv.jmi.ftbchunks.client.GeneralDataOverlay;
import frankv.jmi.waypointmessage.WaypointChatMessage;
import frankv.jmi.waystones.client.WaystoneMarker;
import java.util.EnumSet;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.api.ClientPlugin;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.IClientPlugin;
import journeymap.client.api.event.ClientEvent;
import journeymap.client.api.event.FullscreenMapEvent;
import journeymap.client.api.event.RegistryEvent;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.KnownWaystonesEvent;
import net.minecraftforge.common.MinecraftForge;

@ParametersAreNonnullByDefault
@ClientPlugin
public class JMIJourneyMapPlugin
implements IClientPlugin {
    private IClientAPI jmAPI = null;
    private ClaimedChunkPolygon claimedChunkPolygon;
    private ClaimingMode claimMode;
    public WaystoneMarker waystoneMarker;

    public void initialize(IClientAPI jmAPI) {
        this.jmAPI = jmAPI;
        JMIOverlayHelper.setJmAPI(jmAPI);
        if (JMI.ftbchunks) {
            this.claimedChunkPolygon = new ClaimedChunkPolygon(jmAPI);
            this.claimMode = new ClaimingMode(jmAPI, this.claimedChunkPolygon);
            MinecraftForge.EVENT_BUS.register((Object)this.claimedChunkPolygon);
            MinecraftForge.EVENT_BUS.register((Object)this.claimMode);
            MinecraftForge.EVENT_BUS.register(ClaimingModeHandler.class);
            MinecraftForge.EVENT_BUS.register(GeneralDataOverlay.class);
        }
        if (JMI.waystones) {
            this.waystoneMarker = new WaystoneMarker(jmAPI);
            Balm.getEvents().onEvent(KnownWaystonesEvent.class, event -> this.waystoneMarker.onKnownWaystones((KnownWaystonesEvent)event));
        }
        MinecraftForge.EVENT_BUS.register(WaypointChatMessage.class);
        MinecraftForge.EVENT_BUS.register(JMIForgeEventListener.class);
        this.jmAPI.subscribe(this.getModId(), EnumSet.of(ClientEvent.Type.MAPPING_STARTED, new ClientEvent.Type[]{ClientEvent.Type.MAPPING_STOPPED, ClientEvent.Type.MAP_CLICKED, ClientEvent.Type.MAP_DRAGGED, ClientEvent.Type.MAP_MOUSE_MOVED, ClientEvent.Type.REGISTRY}));
        JMI.LOGGER.info("Initialized " + this.getClass().getName());
    }

    public String getModId() {
        return "jmi";
    }

    public void onEvent(ClientEvent event) {
        try {
            switch (event.type) {
                case MAPPING_STARTED: {
                    if (JMI.ftbchunks) {
                        if (JMIForgeEventListener.firstLogin) {
                            this.disableFTBChunksThings();
                        } else {
                            this.claimedChunkPolygon.createPolygonsOnMappingStarted();
                            JMI.LOGGER.debug("re-added ftbchunks overlays");
                        }
                    }
                    if (JMI.waystones) {
                        this.waystoneMarker.createMarkersOnMappingStarted();
                        JMI.LOGGER.debug("re-added waystones overlays");
                    }
                    JMIForgeEventListener.firstLogin = false;
                    break;
                }
                case MAPPING_STOPPED: {
                    this.clearFTBChunksOverlays();
                    WaystoneMarker.markers.clear();
                    this.jmAPI.removeAll("jmi");
                    JMI.LOGGER.debug("all overlays removed");
                    break;
                }
                case MAP_CLICKED: {
                    if (!(event instanceof FullscreenMapEvent.ClickEvent.Pre)) break;
                    ClaimingModeHandler.preClick((FullscreenMapEvent.ClickEvent)event);
                    break;
                }
                case MAP_DRAGGED: {
                    if (!(event instanceof FullscreenMapEvent.MouseDraggedEvent.Pre)) break;
                    ClaimingModeHandler.preDrag((FullscreenMapEvent.MouseDraggedEvent)event);
                    break;
                }
                case REGISTRY: {
                    RegistryEvent registryEvent = (RegistryEvent)event;
                    switch (registryEvent.getRegistryType()) {
                        case INFO_SLOT: {
                            if (!JMI.ftbchunks) break;
                            ((RegistryEvent.InfoSlotRegistryEvent)registryEvent).register("jmi", "jmi.infoslot.ftbchunks", 1000L, ClaimedChunkPolygon::getPolygonTitleByPlayerPos);
                        }
                    }
                    break;
                }
                case MAP_MOUSE_MOVED: {
                    ClaimingModeHandler.mouseMove((FullscreenMapEvent.MouseMoveEvent)event);
                }
            }
        }
        catch (Throwable t) {
            JMI.LOGGER.error(t.getMessage(), t);
        }
    }

    private void disableFTBChunksThings() {
        if (!JMI.CLIENT_CONFIG.getDisableFTBFunction()) {
            return;
        }
        FTBChunksClientConfig.DEATH_WAYPOINTS.set((Object)false);
        FTBChunksClientConfig.MINIMAP_ENABLED.set((Object)false);
        FTBChunksClientConfig.IN_WORLD_WAYPOINTS.set((Object)false);
    }

    private void clearFTBChunksOverlays() {
        ClaimedChunkPolygon.chunkOverlays.clear();
        ClaimedChunkPolygon.forceLoadedOverlays.clear();
        ClaimingModeHandler.dragPolygons.clear();
    }
}

