/*
 * Decompiled with CFR 0.152.
 */
package frankv.jmi.waystones.client;

import frankv.jmi.JMI;
import frankv.jmi.waystones.client.WaystoneMarkerListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.IOverlayListener;
import journeymap.client.api.display.MarkerOverlay;
import journeymap.client.api.model.MapImage;
import journeymap.client.api.model.TextProperties;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.KnownWaystonesEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class WaystoneMarker {
    private IClientAPI jmAPI;
    private static Minecraft mc = Minecraft.m_91087_();
    public static HashMap<ComparableWaystone, MarkerOverlay> markers = new HashMap();
    public static Set<ComparableWaystone> waystones = new HashSet<ComparableWaystone>();

    public WaystoneMarker(IClientAPI jmAPI) {
        this.jmAPI = jmAPI;
    }

    private void createMarker(ComparableWaystone waystone) {
        ResourceLocation marker = new ResourceLocation("jmi:images/waystone.png");
        MapImage icon = new MapImage(marker, 32, 32).setAnchorX(12.0).setAnchorY(24.0).setDisplayWidth(24.0).setDisplayHeight(24.0).setColor(JMI.CLIENT_CONFIG.getWaystoneColor());
        TextProperties textProperties = new TextProperties().setBackgroundOpacity(0.4f).setOpacity(1.0f);
        MarkerOverlay markerOverlay = new MarkerOverlay("jmi", "waystone_" + waystone.pos, waystone.pos, icon);
        markerOverlay.setDimension(waystone.dim).setLabel(waystone.name).setTextProperties(textProperties);
        markerOverlay.setOverlayListener((IOverlayListener)new WaystoneMarkerListener(markerOverlay, this.jmAPI));
        try {
            this.jmAPI.show((Displayable)markerOverlay);
            markers.put(waystone, markerOverlay);
        }
        catch (Exception e) {
            JMI.LOGGER.error((Object)e);
        }
    }

    private void removeMarker(ComparableWaystone waystone) {
        if (!markers.containsKey(waystone)) {
            return;
        }
        try {
            this.jmAPI.remove((Displayable)markers.remove(waystone));
            markers.remove(waystone);
        }
        catch (Exception e) {
            JMI.LOGGER.error((Object)e);
        }
    }

    public void createMarkersOnMappingStarted() {
        ClientLevel level = WaystoneMarker.mc.f_91073_;
        if (level == null) {
            return;
        }
        for (ComparableWaystone data : waystones) {
            if (!data.dim.equals((Object)level.m_46472_())) continue;
            this.createMarker(data);
        }
    }

    public void onKnownWaystones(KnownWaystonesEvent event) {
        if (!JMI.CLIENT_CONFIG.getWayStone()) {
            return;
        }
        HashSet<ComparableWaystone> newWaystones = new HashSet<ComparableWaystone>(ComparableWaystone.fromEvent(event));
        HashSet<ComparableWaystone> oldWaystones = new HashSet<ComparableWaystone>(markers.keySet());
        if (newWaystones.size() == 1 && oldWaystones.size() > 2) {
            return;
        }
        HashSet<ComparableWaystone> addWaystones = new HashSet<ComparableWaystone>(newWaystones);
        HashSet<ComparableWaystone> rmvWaystones = new HashSet<ComparableWaystone>(oldWaystones);
        rmvWaystones.removeAll(newWaystones);
        addWaystones.removeAll(oldWaystones);
        rmvWaystones.forEach(this::removeMarker);
        addWaystones.forEach(this::createMarker);
        waystones = (Set)newWaystones.clone();
    }

    public record ComparableWaystone(UUID uuid, String name, BlockPos pos, ResourceKey<Level> dim) {
        public static Set<ComparableWaystone> fromEvent(KnownWaystonesEvent event) {
            HashSet<ComparableWaystone> waystones = new HashSet<ComparableWaystone>();
            for (IWaystone w : event.getWaystones()) {
                if (!w.hasName()) continue;
                waystones.add(new ComparableWaystone(w.getWaystoneUid(), w.getName(), w.getPos(), (ResourceKey<Level>)w.getDimension()));
            }
            return waystones;
        }
    }
}

