/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.globaloverridable.GlobalOverridableSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;

public abstract class SettingsHandler {
    protected CompoundTag contentsNbt;
    protected final Runnable markContentsDirty;
    protected final Map<String, ISettingsCategory> settingsCategories = new LinkedHashMap<String, ISettingsCategory>();
    private final Map<Class<?>, List<?>> interfaceCategories = new HashMap();
    private final Map<Class<? extends ISettingsCategory>, ISettingsCategory> typeCategories = new HashMap<Class<? extends ISettingsCategory>, ISettingsCategory>();

    public SettingsHandler(CompoundTag contentsNbt, Runnable markContentsDirty, String playerSettingsTagName, Supplier<InventoryHandler> inventoryHandlerSupplier, Supplier<RenderInfo> renderInfoSupplier) {
        this.contentsNbt = contentsNbt;
        this.markContentsDirty = markContentsDirty;
        this.addSettingsCategories(inventoryHandlerSupplier, renderInfoSupplier, this.getSettingsNbtFromContentsNbt(contentsNbt), playerSettingsTagName);
    }

    protected abstract CompoundTag getSettingsNbtFromContentsNbt(CompoundTag var1);

    private void addSettingsCategories(Supplier<InventoryHandler> inventoryHandlerSupplier, Supplier<RenderInfo> renderInfoSupplier, CompoundTag settingsNbt, String playerSettingsTagName) {
        this.addSettingsCategory(settingsNbt, "global", this.markContentsDirty, (categoryNbt, saveNbt) -> new GlobalOverridableSettingsCategory((CompoundTag)categoryNbt, (Consumer<CompoundTag>)saveNbt, playerSettingsTagName));
        this.addSettingsCategory(settingsNbt, "no_sort", this.markContentsDirty, NoSortSettingsCategory::new);
        this.addSettingsCategory(settingsNbt, "memory", this.markContentsDirty, (categoryNbt, saveNbt) -> new MemorySettingsCategory(inventoryHandlerSupplier, (CompoundTag)categoryNbt, (Consumer<CompoundTag>)saveNbt));
        this.addSettingsCategory(settingsNbt, "item_display", this.markContentsDirty, (categoryNbt, saveNbt) -> new ItemDisplaySettingsCategory(inventoryHandlerSupplier, renderInfoSupplier, (CompoundTag)categoryNbt, (Consumer<CompoundTag>)saveNbt));
    }

    private void addSettingsCategory(CompoundTag settingsNbt, String categoryName, Runnable markContentsDirty, BiFunction<CompoundTag, Consumer<CompoundTag>, ISettingsCategory> instantiateCategory) {
        ISettingsCategory category = instantiateCategory.apply(settingsNbt.m_128469_(categoryName), tag -> {
            this.saveCategoryNbt(settingsNbt, categoryName, (CompoundTag)tag);
            markContentsDirty.run();
        });
        this.settingsCategories.put(categoryName, category);
        this.typeCategories.put(category.getClass(), category);
    }

    protected abstract void saveCategoryNbt(CompoundTag var1, String var2, CompoundTag var3);

    public Map<String, ISettingsCategory> getSettingsCategories() {
        return this.settingsCategories;
    }

    public <T> List<T> getCategoriesThatImplement(Class<T> categoryClass) {
        return this.interfaceCategories.computeIfAbsent(categoryClass, this::getListOfWrappersThatImplement);
    }

    public <T extends ISettingsCategory> T getTypeCategory(Class<T> categoryClazz) {
        return (T)this.typeCategories.get(categoryClazz);
    }

    private <T> List<T> getListOfWrappersThatImplement(Class<T> uc) {
        ArrayList<ISettingsCategory> ret = new ArrayList<ISettingsCategory>();
        for (ISettingsCategory category : this.settingsCategories.values()) {
            if (!uc.isInstance(category)) continue;
            ret.add(category);
        }
        return ret;
    }

    public CompoundTag getNbt() {
        return this.getSettingsNbtFromContentsNbt(this.contentsNbt);
    }

    public void reloadFrom(CompoundTag contentsNbt) {
        CompoundTag settingsNbt = this.getSettingsNbtFromContentsNbt(contentsNbt);
        this.getSettingsCategories().forEach((categoryName, category) -> category.reloadFrom(settingsNbt.m_128469_(categoryName)));
    }
}

