/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.p3pp3rf1y.sophisticatedcore.settings.GlobalOverridableSetting;
import net.p3pp3rf1y.sophisticatedcore.settings.globaloverridable.GlobalOverridableSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class SettingsManager {
    private static final Map<String, GlobalOverridableSetting<?>> settings = new HashMap();
    public static final GlobalOverridableSetting<Boolean> SHIFT_CLICK_INTO_OPEN_TAB_FIRST = new GlobalOverridableSetting<Boolean>("shiftClickOpenTab", NBTHelper::getBoolean, CompoundTag::m_128379_, true);
    public static final GlobalOverridableSetting<Boolean> KEEP_TAB_OPEN = new GlobalOverridableSetting<Boolean>("keepTabOpen", NBTHelper::getBoolean, CompoundTag::m_128379_, true);

    private SettingsManager() {
    }

    public static Optional<GlobalOverridableSetting<?>> getSetting(String settingName) {
        return Optional.ofNullable(settings.get(settingName));
    }

    public static <T> T getPlayerSettingOrDefault(Player player, String playerSettingsTagName, GlobalOverridableSetting<T> setting) {
        return SettingsManager.getPlayerSetting(player, playerSettingsTagName, setting).orElse(setting.getDefaultValue());
    }

    public static <T> Optional<T> getPlayerSetting(Player player, String playerSettingsTagName, GlobalOverridableSetting<T> setting) {
        return setting.getValue(SettingsManager.getPlayerSettingsTag(player, playerSettingsTagName));
    }

    public static CompoundTag getPlayerSettingsTag(Player player, String playerSettingsTagName) {
        return player.getPersistentData().m_128469_(playerSettingsTagName);
    }

    public static void setPlayerSettingsTag(Player player, String playerSettingsTagName, CompoundTag settingsNbt) {
        player.getPersistentData().m_128365_(playerSettingsTagName, (Tag)settingsNbt);
    }

    public static <T> void setPlayerSetting(Player player, String playerSettingsTagName, GlobalOverridableSetting<T> setting, T value) {
        if (!player.getPersistentData().m_128441_(playerSettingsTagName)) {
            player.getPersistentData().m_128365_(playerSettingsTagName, (Tag)new CompoundTag());
        }
        if (value != setting.getDefaultValue()) {
            setting.setValue(SettingsManager.getPlayerSettingsTag(player, playerSettingsTagName), value);
        } else {
            setting.removeFrom(SettingsManager.getPlayerSettingsTag(player, playerSettingsTagName));
        }
    }

    public static <T> void setSetting(Player player, String playerSettingsTagName, GlobalOverridableSettingsCategory category, GlobalOverridableSetting<T> setting, T value) {
        T playerSettingValue = SettingsManager.getPlayerSetting(player, playerSettingsTagName, setting).orElse(setting.getDefaultValue());
        if (playerSettingValue != value) {
            category.setSettingValue(setting, value);
        } else {
            category.removeSetting(setting);
        }
    }

    public static <T> T getSettingValue(Player player, String playerSettingsTagName, GlobalOverridableSettingsCategory category, GlobalOverridableSetting<T> setting) {
        return category.getSettingValue(setting).orElse(SettingsManager.getPlayerSetting(player, playerSettingsTagName, setting).orElse(setting.getDefaultValue()));
    }

    static {
        settings.put(SHIFT_CLICK_INTO_OPEN_TAB_FIRST.getName(), SHIFT_CLICK_INTO_OPEN_TAB_FIRST);
        settings.put(KEEP_TAB_OPEN.getName(), KEEP_TAB_OPEN);
    }
}

