/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IWorkMonitor;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.computer.MainThread;
import dan200.computercraft.core.tracking.Tracking;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

final class MainThreadExecutor
implements IWorkMonitor {
    private static final int MAX_TASKS = 5000;
    private final Computer computer;
    private final Object queueLock = new Object();
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>(4);
    volatile boolean onQueue;
    private long budget = 0L;
    private int currentTick = -1;
    private State state = State.COOL;
    private long pendingTime;
    long virtualTime;

    MainThreadExecutor(Computer computer) {
        this.computer = computer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueue(Runnable runnable) {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.tasks.size() >= 5000 || !this.tasks.offer(runnable)) {
                return false;
            }
            if (!this.onQueue && this.state == State.COOL) {
                MainThread.queue(this, true);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute() {
        Runnable task;
        if (this.state != State.COOL) {
            return;
        }
        Object object = this.queueLock;
        synchronized (object) {
            task = this.tasks.poll();
        }
        if (task != null) {
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean afterExecute(long time) {
        this.consumeTime(time);
        Object object = this.queueLock;
        synchronized (object) {
            this.virtualTime += time;
            this.updateTime();
            if (this.state != State.COOL || this.tasks.isEmpty()) {
                this.onQueue = false;
                return false;
            }
            return true;
        }
    }

    @Override
    public boolean canWork() {
        return this.state != State.COOLING && MainThread.canExecute();
    }

    @Override
    public boolean shouldWork() {
        return this.state == State.COOL && MainThread.canExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trackWork(long time, @Nonnull TimeUnit unit) {
        long nanoTime = unit.toNanos(time);
        Object object = this.queueLock;
        synchronized (object) {
            this.pendingTime += nanoTime;
        }
        this.consumeTime(nanoTime);
        MainThread.consumeTime(nanoTime);
    }

    private void consumeTime(long time) {
        Tracking.addServerTiming(this.computer, time);
        if (this.currentTick != MainThread.currentTick()) {
            this.currentTick = MainThread.currentTick();
            this.budget = ComputerCraft.maxMainComputerTime;
        }
        this.budget -= time;
        if (this.budget < 0L && this.state == State.COOL) {
            this.state = State.HOT;
            MainThread.cooling(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tickCooling() {
        this.state = State.COOLING;
        this.currentTick = MainThread.currentTick();
        this.budget = Math.min(this.budget + ComputerCraft.maxMainComputerTime, ComputerCraft.maxMainComputerTime);
        if (this.budget < ComputerCraft.maxMainComputerTime) {
            return false;
        }
        this.state = State.COOL;
        Object object = this.queueLock;
        synchronized (object) {
            if (!this.tasks.isEmpty() && !this.onQueue) {
                MainThread.queue(this, false);
            }
        }
        return true;
    }

    void updateTime() {
        this.virtualTime += this.pendingTime;
        this.pendingTime = 0L;
    }

    private static enum State {
        COOL,
        HOT,
        COOLING;

    }
}

