/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.commandblock;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.util.CapabilityUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CommandBlockPeripheral
implements IPeripheral,
ICapabilityProvider {
    private static final ResourceLocation CAP_ID = new ResourceLocation("computercraft", "command_block");
    private final CommandBlockEntity commandBlock;
    private LazyOptional<IPeripheral> self;

    public CommandBlockPeripheral(CommandBlockEntity commandBlock) {
        this.commandBlock = commandBlock;
    }

    @Override
    @Nonnull
    public String getType() {
        return "command";
    }

    @LuaFunction(mainThread=true)
    public final String getCommand() {
        return this.commandBlock.m_59141_().m_45438_();
    }

    @LuaFunction(mainThread=true)
    public final void setCommand(String command) {
        this.commandBlock.m_59141_().m_6590_(command);
        this.commandBlock.m_59141_().m_7368_();
    }

    @LuaFunction(mainThread=true)
    public final Object[] runCommand() {
        Object[] objectArray;
        this.commandBlock.m_59141_().m_45414_(this.commandBlock.m_58904_());
        int result = this.commandBlock.m_59141_().m_45436_();
        if (result > 0) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = true;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = false;
            objectArray = objectArray3;
            objectArray3[1] = "Command failed";
        }
        return objectArray;
    }

    @Override
    public boolean equals(IPeripheral other) {
        return other != null && other.getClass() == this.getClass();
    }

    @Override
    @Nonnull
    public Object getTarget() {
        return this.commandBlock;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.self == null) {
                this.self = LazyOptional.of(() -> this);
            }
            return this.self.cast();
        }
        return LazyOptional.empty();
    }

    private void invalidate() {
        this.self = CapabilityUtil.invalidate(this.self);
    }

    @SubscribeEvent
    public static void onCapability(AttachCapabilitiesEvent<BlockEntity> event) {
        BlockEntity tile = (BlockEntity)event.getObject();
        if (ComputerCraft.enableCommandBlock && tile instanceof CommandBlockEntity) {
            CommandBlockPeripheral peripheral = new CommandBlockPeripheral((CommandBlockEntity)tile);
            event.addCapability(CAP_ID, (ICapabilityProvider)peripheral);
            event.addListener(peripheral::invalidate);
        }
    }
}

