/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.apis;

import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class PocketAPI
implements ILuaAPI {
    private final PocketServerComputer computer;

    public PocketAPI(PocketServerComputer computer) {
        this.computer = computer;
    }

    @Override
    public String[] getNames() {
        return new String[]{"pocket"};
    }

    @LuaFunction(mainThread=true)
    public final Object[] equipBack() {
        ItemStack stack;
        Entity entity = this.computer.getEntity();
        if (!(entity instanceof Player)) {
            return new Object[]{false, "Cannot find player"};
        }
        Player player = (Player)entity;
        Inventory inventory = player.m_150109_();
        IPocketUpgrade previousUpgrade = this.computer.getUpgrade();
        IPocketUpgrade newUpgrade = PocketAPI.findUpgrade((NonNullList<ItemStack>)inventory.f_35974_, inventory.f_35977_, previousUpgrade);
        if (newUpgrade == null) {
            newUpgrade = PocketAPI.findUpgrade((NonNullList<ItemStack>)inventory.f_35976_, 0, previousUpgrade);
        }
        if (newUpgrade == null) {
            return new Object[]{false, "Cannot find a valid upgrade"};
        }
        if (previousUpgrade != null && !(stack = previousUpgrade.getCraftingItem()).m_41619_() && !(stack = InventoryUtil.storeItems(stack, (IItemHandler)new PlayerMainInvWrapper(inventory), inventory.f_35977_)).m_41619_()) {
            WorldUtil.dropItemStack(stack, player.m_20193_(), player.m_20182_());
        }
        this.computer.setUpgrade(newUpgrade);
        return new Object[]{true};
    }

    @LuaFunction(mainThread=true)
    public final Object[] unequipBack() {
        Entity entity = this.computer.getEntity();
        if (!(entity instanceof Player)) {
            return new Object[]{false, "Cannot find player"};
        }
        Player player = (Player)entity;
        Inventory inventory = player.m_150109_();
        IPocketUpgrade previousUpgrade = this.computer.getUpgrade();
        if (previousUpgrade == null) {
            return new Object[]{false, "Nothing to unequip"};
        }
        this.computer.setUpgrade(null);
        ItemStack stack = previousUpgrade.getCraftingItem();
        if (!stack.m_41619_() && (stack = InventoryUtil.storeItems(stack, (IItemHandler)new PlayerMainInvWrapper(inventory), inventory.f_35977_)).m_41619_()) {
            WorldUtil.dropItemStack(stack, player.m_20193_(), player.m_20182_());
        }
        return new Object[]{true};
    }

    private static IPocketUpgrade findUpgrade(NonNullList<ItemStack> inv, int start, IPocketUpgrade previous) {
        for (int i = 0; i < inv.size(); ++i) {
            IPocketUpgrade newUpgrade;
            ItemStack invStack = (ItemStack)inv.get((i + start) % inv.size());
            if (invStack.m_41619_() || (newUpgrade = PocketUpgrades.instance().get(invStack)) == null || newUpgrade == previous) continue;
            invStack = invStack.m_41777_();
            invStack.m_41774_(1);
            inv.set((i + start) % inv.size(), (Object)(invStack.m_41619_() ? ItemStack.f_41583_ : invStack));
            return newUpgrade;
        }
        return null;
    }
}

