/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.Varargs;

public final class YieldThreader
implements Executor {
    private final Executor executor;
    final Lock lock = new ReentrantLock();
    final Condition loop = this.lock.newCondition();
    volatile boolean running;
    volatile Varargs args;
    private volatile Throwable error;

    YieldThreader(Executor coroutineExecutor) {
        this.executor = coroutineExecutor;
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    Varargs unpack() throws LuaError {
        Varargs result = this.args;
        Throwable error = this.error;
        this.args = null;
        this.error = null;
        if (error != null) {
            YieldThreader.rethrow(error);
            throw (LuaError)error;
        }
        return result;
    }

    void set(Throwable error) {
        this.args = null;
        this.error = error;
    }

    void set(Varargs args) {
        this.args = args;
        this.error = null;
    }

    private static <T extends Throwable> void rethrow(Throwable e) throws T {
        throw e;
    }
}

