/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import io.github.lightman314.lightmanscurrency.blockentity.ItemInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.TickableBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.interfacebe.MessageHandlerMessage;
import io.github.lightman314.lightmanscurrency.trader.common.TradeContext;
import io.github.lightman314.lightmanscurrency.trader.interfacing.UniversalTradeReference;
import io.github.lightman314.lightmanscurrency.trader.interfacing.handlers.SidedHandler;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.EnumUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public abstract class UniversalTraderInterfaceBlockEntity<T extends TradeData>
extends TickableBlockEntity {
    public static final int INTERACTION_DELAY = 20;
    PlayerReference owner = null;
    boolean linkToAccount = false;
    List<SidedHandler<?>> handlers = new ArrayList();
    private boolean isActive = false;
    private InteractionType interaction = InteractionType.TRADE;
    UniversalTradeReference<T> reference = new UniversalTradeReference<TradeData>(this::isClient, this::deserializeTrade);
    private TradeContext.TradeResult lastResult = TradeContext.TradeResult.SUCCESS;
    private int waitTimer = 20;
    public final Function<CompoundTag, T> tradeDeserializer;

    public PlayerReference getOwner() {
        return this.owner;
    }

    public void initOwner(Entity owner) {
        if (this.owner == null) {
            this.owner = PlayerReference.of(owner);
        }
    }

    public void setLinkToAccount(boolean linkToAccount) {
        this.linkToAccount = true;
    }

    public boolean interactionActive() {
        return this.isActive;
    }

    public void toggleActive() {
        this.isActive = !this.isActive;
        this.setActiveDirty();
    }

    public InteractionType getInteractionType() {
        return this.interaction;
    }

    public void setInteractionType(InteractionType type) {
        this.interaction = type;
        this.setInteractionDirty();
    }

    public UniversalTraderData getTrader() {
        return this.reference.getTrader();
    }

    public int getTradeIndex() {
        return this.reference.getTradeIndex();
    }

    public T getReferencedTrade() {
        return this.reference.getLocalTrade();
    }

    public T getTrueTrade() {
        return this.reference.getTrueTrade();
    }

    public void setTrader(UUID traderID) {
        if (this.reference.getTraderID() != null && this.reference.getTraderID().equals(traderID)) {
            return;
        }
        this.reference.setTrader(traderID);
        this.reference.setTrade(-1);
        this.setTradeReferenceDirty();
    }

    public void setTradeIndex(int tradeIndex) {
        this.reference.setTrade(tradeIndex);
        this.setTradeReferenceDirty();
    }

    public TradeContext.TradeResult mostRecentTradeResult() {
        return this.lastResult;
    }

    protected abstract T deserializeTrade(CompoundTag var1);

    public BankAccount.AccountReference getBankAccount() {
        if (this.owner != null && this.linkToAccount) {
            return BankAccount.GenerateReference(this.isClient(), this.owner);
        }
        return null;
    }

    public boolean isOwner(Entity player) {
        if (this.owner != null && this.owner.is(player)) {
            return true;
        }
        if (player instanceof Player) {
            return TradingOffice.isAdminPlayer((Player)player);
        }
        return false;
    }

    protected UniversalTraderInterfaceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, Function<CompoundTag, T> tradeDeserializer) {
        super(type, pos, state);
        this.tradeDeserializer = tradeDeserializer;
    }

    public void setActiveDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveActivated(new CompoundTag()));
        }
    }

    public void setLastResultDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveLastResult(new CompoundTag()));
        }
    }

    public abstract TradeContext getRemoteTradeData();

    public boolean isClient() {
        return this.f_58857_ != null ? this.f_58857_.f_46443_ : true;
    }

    protected final <H extends SidedHandler<?>> H addHandler(@Nonnull H handler) {
        handler.setParent(this);
        this.handlers.add(handler);
        return handler;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    protected void m_183515_(CompoundTag compound) {
        this.saveOwner(compound);
        this.saveActivated(compound);
        this.saveInteraction(compound);
        this.saveLastResult(compound);
        this.saveReference(compound);
        for (SidedHandler<?> handler : this.handlers) {
            this.saveHandler(compound, handler);
        }
    }

    protected final CompoundTag saveOwner(CompoundTag compound) {
        if (this.owner != null) {
            compound.m_128365_("Owner", (Tag)this.owner.save());
        }
        return compound;
    }

    protected final CompoundTag saveActivated(CompoundTag compound) {
        compound.m_128379_("Activated", this.isActive);
        return compound;
    }

    protected final CompoundTag saveInteraction(CompoundTag compound) {
        compound.m_128359_("InteractionType", this.interaction.name());
        return compound;
    }

    protected final CompoundTag saveLastResult(CompoundTag compound) {
        compound.m_128359_("LastResult", this.lastResult.name());
        return compound;
    }

    protected final CompoundTag saveReference(CompoundTag compound) {
        compound.m_128365_("Trade", (Tag)this.reference.save());
        return compound;
    }

    protected final CompoundTag saveHandler(CompoundTag compound, SidedHandler<?> handler) {
        compound.m_128365_(handler.getTag(), (Tag)handler.save());
        return compound;
    }

    public void setHandlerDirty(SidedHandler<?> handler) {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveHandler(new CompoundTag(), handler));
        }
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128425_("Owner", 10)) {
            this.owner = PlayerReference.load(compound.m_128469_("Owner"));
        }
        if (compound.m_128441_("Activated")) {
            this.isActive = compound.m_128471_("Activated");
        }
        if (compound.m_128425_("InteractionType", 8)) {
            this.interaction = (InteractionType)EnumUtil.enumFromString((String)compound.m_128461_("InteractionType"), (Enum[])InteractionType.values(), (Enum)InteractionType.TRADE);
        }
        if (compound.m_128425_("Trade", 10)) {
            this.reference.load(compound.m_128469_("Trade"));
        }
        for (SidedHandler<?> handler : this.handlers) {
            if (!compound.m_128425_(handler.getTag(), 10)) continue;
            handler.load(compound.m_128469_(handler.getTag()));
        }
    }

    public void setInteractionDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveInteraction(new CompoundTag()));
        }
    }

    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> cap, @Nullable Direction side) {
        Direction relativeSide = this.getRelativeSide(side);
        for (int i = 0; i < this.handlers.size(); ++i) {
            Object handler = this.handlers.get(i).getHandler(relativeSide);
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && handler instanceof IItemHandler) {
                return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> (IItemHandler)handler));
            }
            if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && handler instanceof IFluidHandler) {
                return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> (IFluidHandler)handler));
            }
            if (cap != CapabilityEnergy.ENERGY || !(handler instanceof IEnergyStorage)) continue;
            return CapabilityEnergy.ENERGY.orEmpty(cap, LazyOptional.of(() -> (IEnergyStorage)handler));
        }
        return super.getCapability(cap, side);
    }

    protected final Direction getRelativeSide(Direction side) {
        Direction relativeSide = side;
        if (relativeSide != null & this.m_58900_().m_60734_() instanceof IRotatableBlock) {
            relativeSide = ItemInterfaceBlockEntity.IItemHandlerBlock.getRelativeSide(((IRotatableBlock)this.m_58900_().m_60734_()).getFacing(this.m_58900_()), side);
        }
        return relativeSide;
    }

    public void sendHandlerMessage(ResourceLocation type, CompoundTag message) {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageHandlerMessage(this.f_58858_, type, message));
        }
    }

    public void receiveHandlerMessage(ResourceLocation type, Player player, CompoundTag message) {
        if (!this.isOwner((Entity)player)) {
            return;
        }
        for (int i = 0; i < this.handlers.size(); ++i) {
            if (!this.handlers.get(i).getType().equals((Object)type)) continue;
            this.handlers.get(i).receiveMessage(message);
        }
    }

    public void setTradeReferenceDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.saveReference(new CompoundTag()));
        }
    }

    public TradeContext.TradeResult interactWithTrader() {
        TradeContext remoteTradeData = this.getRemoteTradeData();
        UniversalTraderData trader = this.getTrader();
        this.lastResult = trader != null ? trader.handleRemotePurchase(this.reference.getTradeIndex(), remoteTradeData) : TradeContext.TradeResult.FAIL_NULL;
        this.setLastResultDirty();
        return this.lastResult;
    }

    @Override
    public void serverTick() {
        if (this.isActive) {
            --this.waitTimer;
            if (this.waitTimer <= 0) {
                this.waitTimer = 20;
                if (this.interaction.requiresPermissions) {
                    if (!this.validTrader()) {
                        this.isActive = false;
                        this.setActiveDirty();
                        return;
                    }
                    if (this.interaction.drains) {
                        this.drainTick();
                    }
                    if (this.interaction.restocks) {
                        this.restockTick();
                    }
                } else if (this.interaction.trades) {
                    if (!this.validTrade()) {
                        this.isActive = false;
                        this.setActiveDirty();
                        return;
                    }
                    this.tradeTick();
                }
            }
        }
    }

    public boolean validTrader() {
        UniversalTraderData trader = this.reference.getTrader();
        return trader != null && this.validTraderType(trader);
    }

    public boolean hasTraderPermissions() {
        UniversalTraderData trader = this.reference.getTrader();
        if (trader != null && this.owner != null) {
            return trader.hasPermission(this.owner, "interactionLink");
        }
        return false;
    }

    public boolean validTrade() {
        T expectedTrade = this.getReferencedTrade();
        T trueTrade = this.getTrueTrade();
        if (expectedTrade == null || trueTrade == null) {
            return false;
        }
        return ((TradeData)expectedTrade).AcceptableDifferences(((TradeData)expectedTrade).compare((TradeData)trueTrade));
    }

    protected abstract boolean validTraderType(UniversalTraderData var1);

    protected abstract void drainTick();

    protected abstract void restockTick();

    protected abstract void tradeTick();

    public void openMenu(Player player) {
        if (this.isOwner((Entity)player)) {
            MenuProvider provider = this.getMenuProvider();
            if (provider == null) {
                return;
            }
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (BlockPos)this.f_58858_);
        }
    }

    protected abstract MenuProvider getMenuProvider();

    public abstract void dumpContents(Level var1, BlockPos var2);

    public static enum InteractionType {
        RESTOCK_AND_DRAIN(true, true, true, false, 1),
        RESTOCK(true, true, false, false, 2),
        DRAIN(true, false, true, false, 3),
        TRADE(false, false, false, true, 0);

        public final boolean requiresPermissions;
        public final boolean restocks;
        public final boolean drains;
        public final boolean trades;
        public final int index;

        public final Component getDisplayText() {
            return new TranslatableComponent("gui.lightmanscurrency.interface.type." + this.name().toLowerCase());
        }

        public final InteractionType getNext() {
            return InteractionType.fromIndex(this.index + 1);
        }

        private InteractionType(boolean requiresPermissions, boolean restocks, boolean drains, boolean trades, int index) {
            this.requiresPermissions = requiresPermissions;
            this.restocks = restocks;
            this.drains = drains;
            this.trades = trades;
            this.index = index;
        }

        public static InteractionType fromIndex(int index) {
            for (InteractionType type : InteractionType.values()) {
                if (type.index != index) continue;
                return type;
            }
            return InteractionType.fromIndex(0);
        }

        public static int size() {
            return 4;
        }
    }
}

