/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks.tradeinterface.templates;

import io.github.lightman314.lightmanscurrency.blockentity.TickableBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.UniversalTraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.interfaces.IOwnableBlock;
import io.github.lightman314.lightmanscurrency.blocks.templates.RotatableBlock;
import io.github.lightman314.lightmanscurrency.blocks.util.TickerUtil;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public abstract class TraderInterfaceBlock
extends RotatableBlock
implements EntityBlock,
IOwnableBlock {
    protected TraderInterfaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TickerUtil.createTickerHelper(type, this.interfaceType(), TickableBlockEntity::tickHandler);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        UniversalTraderInterfaceBlockEntity<?> blockEntity;
        if (!level.f_46443_ && (blockEntity = this.getBlockEntity((LevelAccessor)level, pos, state)) != null) {
            BlockEntityUtil.sendUpdatePacket(blockEntity);
            blockEntity.openMenu(player);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        UniversalTraderInterfaceBlockEntity<?> blockEntity;
        if (!level.f_46443_ && (blockEntity = this.getBlockEntity((LevelAccessor)level, pos, state)) != null) {
            blockEntity.initOwner((Entity)player);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        UniversalTraderInterfaceBlockEntity<?> blockEntity = this.getBlockEntity((LevelAccessor)level, pos, state);
        if (blockEntity != null) {
            if (!blockEntity.isOwner((Entity)player)) {
                return;
            }
            blockEntity.dumpContents(level, pos);
        }
        super.m_5707_(level, pos, state, player);
    }

    @Override
    public boolean canBreak(Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        UniversalTraderInterfaceBlockEntity<?> be = this.getBlockEntity(level, pos, state);
        if (be == null) {
            return true;
        }
        return be.isOwner((Entity)player);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.createBlockEntity(pos, state);
    }

    protected abstract BlockEntity createBlockEntity(BlockPos var1, BlockState var2);

    protected abstract BlockEntityType<?> interfaceType();

    protected final UniversalTraderInterfaceBlockEntity<?> getBlockEntity(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof UniversalTraderInterfaceBlockEntity) {
            return (UniversalTraderInterfaceBlockEntity)be;
        }
        return null;
    }
}

