/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks.traderblocks;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.blockentity.ArmorDisplayTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.ItemInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.interfaces.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.templates.TraderBlockTallRotatable;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ArmorDisplayBlock
extends TraderBlockTallRotatable
implements IItemTraderBlock {
    public static final int TRADECOUNT = 4;

    public ArmorDisplayBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockEntity makeTrader(BlockPos pos, BlockState state) {
        return new ArmorDisplayTraderBlockEntity(pos, state);
    }

    @Override
    protected BlockEntity makeDummy(BlockPos pos, BlockState state) {
        return new ItemInterfaceBlockEntity(pos, state);
    }

    @Override
    public BlockEntityType<?> traderType() {
        return ModBlockEntities.ARMOR_TRADER;
    }

    @Override
    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        ArmorDisplayTraderBlockEntity trader;
        BlockEntity blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos);
        if (blockEntity instanceof ArmorDisplayTraderBlockEntity && (trader = (ArmorDisplayTraderBlockEntity)blockEntity).canBreak(player)) {
            trader.destroyArmorStand();
        }
        super.m_5707_(level, pos, state, player);
    }

    @Override
    public List<Vector3f> GetStackRenderPos(int tradeSlot, BlockState state, boolean isBlock) {
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Quaternion> GetStackRenderRot(int tradeSlot, BlockState state, boolean isBlock) {
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vector3f GetStackRenderScale(int tradeSlot, BlockState state, boolean isBlock) {
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int maxRenderIndex() {
        return -1;
    }

    @Override
    public Direction getRelativeSide(BlockState state, Direction side) {
        return ItemInterfaceBlockEntity.IItemHandlerBlock.getRelativeSide(this.getFacing(state), side);
    }

    @Override
    public ItemInterfaceBlockEntity.IItemHandlerBlockEntity getItemHandlerEntity(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos);
        if (blockEntity instanceof ItemInterfaceBlockEntity.IItemHandlerBlockEntity) {
            return (ItemInterfaceBlockEntity.IItemHandlerBlockEntity)blockEntity;
        }
        return null;
    }
}

