/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.itemInterface;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.blockentity.UniversalTraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradingTerminalScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ItemInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.itemInterface.ItemInterfaceTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.UniversalTraderButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.menus.ItemInterfaceMenu;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.interfacebe.MessageSetTrader;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class TraderSelectTab
extends ItemInterfaceTab {
    EditBox searchField;
    Button buttonPreviousPage;
    Button buttonNextPage;
    List<UniversalTraderButton> traderButtons;
    private int page = 0;
    private List<UniversalTraderData> filteredTraderList = new ArrayList<UniversalTraderData>();

    public TraderSelectTab(ItemInterfaceScreen screen) {
        super(screen, true);
    }

    private List<UniversalTraderData> traderList() {
        List<UniversalTraderData> traderList = this.filterItemTraders(ClientTradingOffice.getTraderList());
        traderList.sort(TradingTerminalScreen.TERMINAL_SORTER);
        return traderList;
    }

    private List<UniversalTraderData> filterItemTraders(List<UniversalTraderData> allTraders) {
        ArrayList<UniversalTraderData> itemTraders = new ArrayList<UniversalTraderData>();
        for (UniversalTraderData trader : allTraders) {
            if (!(trader instanceof IItemTrader)) continue;
            UniversalTraderInterfaceBlockEntity.InteractionType interaction = ((ItemInterfaceMenu)this.screen.m_6262_()).blockEntity.getInteractionType();
            if (interaction.requiresPermissions && !trader.hasPermission(((ItemInterfaceMenu)this.screen.m_6262_()).blockEntity.getOwner(), "interactionLink")) continue;
            itemTraders.add(trader);
        }
        return itemTraders;
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public IconData getIcon() {
        return IconData.of(ModBlocks.TERMINAL);
    }

    @Override
    public Component getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.interface.trader");
    }

    @Override
    public boolean valid(UniversalTraderInterfaceBlockEntity.InteractionType interaction) {
        return true;
    }

    @Override
    public void init() {
        this.searchField = this.screen.addRenderableTabWidget(new EditBox(this.screen.getFont(), this.screen.getGuiLeft() + 28, this.screen.getGuiTop() + 6, 101, 9, (Component)new TranslatableComponent("gui.lightmanscurrency.terminal.search")));
        this.searchField.m_94182_(false);
        this.searchField.m_94199_(32);
        this.searchField.m_94202_(0xFFFFFF);
        this.buttonPreviousPage = this.screen.addRenderableTabWidget(IconAndButtonUtil.leftButton(this.screen.getGuiLeft(), this.screen.getGuiTop() - 20, this::PreviousPage));
        this.buttonNextPage = this.screen.addRenderableTabWidget(IconAndButtonUtil.rightButton(this.screen.getGuiLeft() + this.screen.getXSize() - 20, this.screen.getGuiTop() - 20, this::NextPage));
        this.initTraderButtons(this.screen.getGuiLeft(), this.screen.getGuiTop());
        this.page = MathUtil.clamp(this.page, 0, this.pageLimit());
        this.tick();
        this.updateTraderList();
    }

    private void initTraderButtons(int guiLeft, int guiTop) {
        this.traderButtons = new ArrayList<UniversalTraderButton>();
        for (int y = 0; y < 3; ++y) {
            UniversalTraderButton newButton = this.screen.addRenderableTabWidget(new UniversalTraderButton(guiLeft + 15, guiTop + 18 + y * 30, this::SelectTrader, this.screen.getFont()));
            this.traderButtons.add(newButton);
        }
    }

    @Override
    public void preRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void postRender(PoseStack pose, int mouseX, int mouseY) {
    }

    @Override
    public void tick() {
        this.searchField.m_94120_();
        this.buttonPreviousPage.f_93624_ = this.pageLimit() > 0;
        this.buttonPreviousPage.f_93623_ = this.page > 0;
        this.buttonNextPage.f_93624_ = this.pageLimit() > 0;
        this.buttonNextPage.f_93623_ = this.page < this.pageLimit();
        for (int i = 0; i < this.traderButtons.size(); ++i) {
            UniversalTraderButton button = this.traderButtons.get(i);
            button.selected = button.getData() != null && button.getData() == ((ItemInterfaceMenu)this.screen.m_6262_()).blockEntity.getTrader();
        }
    }

    @Override
    public boolean charTyped(char c, int code) {
        String s = this.searchField.m_94155_();
        if (this.searchField.m_5534_(c, code)) {
            if (!Objects.equals(s, this.searchField.m_94155_())) {
                this.updateTraderList();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int mods) {
        String s = this.searchField.m_94155_();
        if (this.searchField.m_7933_(key, scanCode, mods)) {
            if (!Objects.equals(s, this.searchField.m_94155_())) {
                this.updateTraderList();
            }
            return true;
        }
        return false;
    }

    @Override
    public void onClose() {
    }

    private void PreviousPage(Button button) {
        if (this.page > 0) {
            --this.page;
            this.updateTraderButtons();
        }
    }

    private void NextPage(Button button) {
        if (this.page < this.pageLimit()) {
            ++this.page;
            this.updateTraderButtons();
        }
    }

    private void SelectTrader(Button button) {
        int index = this.getTraderIndex(button);
        if (index >= 0 && index < this.filteredTraderList.size()) {
            UUID traderID = this.filteredTraderList.get(index).getTraderID();
            ((ItemInterfaceMenu)this.screen.m_6262_()).blockEntity.setTrader(traderID);
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSetTrader(((ItemInterfaceMenu)this.screen.m_6262_()).blockEntity.m_58899_(), traderID));
        }
    }

    private int getTraderIndex(Button button) {
        if (!this.traderButtons.contains(button)) {
            return -1;
        }
        int index = this.traderButtons.indexOf(button);
        return index += this.page * this.traderButtons();
    }

    private int pageLimit() {
        return (this.filteredTraderList.size() - 1) / this.traderButtons();
    }

    private int traderButtons() {
        return this.traderButtons.size();
    }

    private void updateTraderList() {
        this.filteredTraderList = TradingOffice.filterTraders(this.searchField.m_94155_(), this.traderList());
        this.updateTraderButtons();
        if (this.page > this.pageLimit()) {
            this.page = this.pageLimit();
        }
    }

    private void updateTraderButtons() {
        int startIndex = this.page * this.traderButtons();
        for (int i = 0; i < this.traderButtons.size(); ++i) {
            if (startIndex + i < this.filteredTraderList.size()) {
                this.traderButtons.get(i).SetData(this.filteredTraderList.get(startIndex + i));
                continue;
            }
            this.traderButtons.get(i).SetData(null);
        }
    }
}

