/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.settings.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TraderSettingsScreen;
import io.github.lightman314.lightmanscurrency.client.gui.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.CoreTraderSettings;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import java.util.Objects;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.ItemLike;

public class MainTab
extends SettingsTab {
    public static final MainTab INSTANCE = new MainTab();
    EditBox nameInput;
    Button buttonSetName;
    Button buttonResetName;
    PlainButton buttonToggleBankLink;
    IconButton buttonToggleCreative;
    Button buttonAddTrade;
    Button buttonRemoveTrade;
    Button buttonSavePersistentTrader;

    private MainTab() {
    }

    @Override
    public ImmutableList<String> requiredPermissions() {
        return ImmutableList.of();
    }

    @Override
    public void initTab() {
        TraderSettingsScreen screen = this.getScreen();
        CoreTraderSettings coreSettings = this.getSetting(CoreTraderSettings.class);
        this.nameInput = screen.addRenderableTabWidget(new EditBox(screen.getFont(), screen.guiLeft() + 20, screen.guiTop() + 25, 160, 20, (Component)new TextComponent("")));
        this.nameInput.m_94199_(32);
        this.nameInput.m_94144_(coreSettings.getCustomName());
        this.buttonSetName = screen.addRenderableTabWidget(new Button(screen.guiLeft() + 20, screen.guiTop() + 50, 74, 20, (Component)new TranslatableComponent("gui.lightmanscurrency.changename"), this::SetName));
        int n = screen.guiLeft();
        Objects.requireNonNull(screen);
        this.buttonResetName = screen.addRenderableTabWidget(new Button(n + 200 - 93, screen.guiTop() + 50, 74, 20, (Component)new TranslatableComponent("gui.lightmanscurrency.resetname"), this::ResetName));
        this.buttonToggleCreative = screen.addRenderableTabWidget(IconAndButtonUtil.creativeToggleButton(screen.guiLeft() + 176, screen.guiTop() + 4, this::ToggleCreative, () -> this.getScreen().getSetting(CoreTraderSettings.class).isCreative()));
        this.buttonAddTrade = screen.addRenderableTabWidget(new PlainButton(screen.guiLeft() + 166, screen.guiTop() + 4, 10, 10, this::AddTrade, TraderSettingsScreen.GUI_TEXTURE, 0, 200));
        this.buttonRemoveTrade = screen.addRenderableTabWidget(new PlainButton(screen.guiLeft() + 166, screen.guiTop() + 14, 10, 10, this::RemoveTrade, TraderSettingsScreen.GUI_TEXTURE, 0, 220));
        this.buttonToggleBankLink = screen.addRenderableTabWidget(new PlainButton(screen.guiLeft() + 20, screen.guiTop() + 100, 10, 10, this::ToggleBankLink, TraderSettingsScreen.GUI_TEXTURE, 10, coreSettings.isBankAccountLinked() ? 200 : 220));
        this.buttonToggleBankLink.f_93624_ = screen.hasPermission("bankLink");
        if (this.getScreen().getTrader() instanceof UniversalTraderData) {
            int n2 = screen.guiLeft() + 10;
            int n3 = screen.guiTop();
            Objects.requireNonNull(screen);
            this.buttonSavePersistentTrader = screen.addRenderableTabWidget(new IconButton(n2, n3 + 200 - 30, this::SavePersistentTraderData, IconAndButtonUtil.ICON_PERSISTENT_DATA, (Button.OnTooltip)IconAndButtonUtil.TOOLTIP_PERSISTENT_DATA));
            this.buttonSavePersistentTrader.f_93624_ = TradingOffice.isAdminPlayer(this.getPlayer());
        }
        this.tick();
    }

    @Override
    public void preRender(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        TraderSettingsScreen screen = this.getScreen();
        screen.getFont().m_92889_(matrix, (Component)new TranslatableComponent("gui.lightmanscurrency.customname"), (float)(screen.guiLeft() + 20), (float)(screen.guiTop() + 15), 0x404040);
        if (screen.hasPermission("bankLink")) {
            this.getFont().m_92889_(matrix, (Component)new TranslatableComponent("gui.lightmanscurrency.settings.banklink"), (float)(screen.guiLeft() + 32), (float)(screen.guiTop() + 101), 0x404040);
        }
    }

    @Override
    public void postRender(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        TraderSettingsScreen screen = this.getScreen();
        IconAndButtonUtil.renderButtonTooltips(matrix, mouseX, mouseY, Lists.newArrayList((Object[])new Widget[]{this.buttonToggleCreative, this.buttonSavePersistentTrader}));
        if (this.buttonAddTrade.m_5953_((double)mouseX, (double)mouseY)) {
            screen.m_96602_(matrix, (Component)new TranslatableComponent("tooltip.lightmanscurrency.trader.creative.addTrade"), mouseX, mouseY);
        } else if (this.buttonRemoveTrade.m_5953_((double)mouseX, (double)mouseY)) {
            screen.m_96602_(matrix, (Component)new TranslatableComponent("tooltip.lightmanscurrency.trader.creative.removeTrade"), mouseX, mouseY);
        }
    }

    @Override
    public void tick() {
        boolean canLinkAccount;
        boolean canChangeName = this.getScreen().hasPermission("changeName");
        this.nameInput.m_94186_(canChangeName);
        this.nameInput.m_94120_();
        CoreTraderSettings coreSettings = this.getSetting(CoreTraderSettings.class);
        this.buttonSetName.f_93623_ = !this.nameInput.m_94155_().contentEquals(coreSettings.getCustomName());
        this.buttonSetName.f_93624_ = canChangeName;
        this.buttonResetName.f_93623_ = coreSettings.hasCustomName();
        this.buttonResetName.f_93624_ = canChangeName;
        this.buttonToggleCreative.f_93624_ = TradingOffice.isAdminPlayer(this.getScreen().getPlayer());
        if (this.buttonToggleCreative.f_93624_) {
            if (coreSettings.isCreative()) {
                ITrader trader = this.getScreen().getTrader();
                this.buttonAddTrade.f_93624_ = true;
                this.buttonAddTrade.f_93623_ = trader.getTradeCount() < trader.getTradeCountLimit();
                this.buttonRemoveTrade.f_93624_ = true;
                this.buttonRemoveTrade.f_93623_ = trader.getTradeCount() > 1;
            } else {
                this.buttonAddTrade.f_93624_ = false;
                this.buttonRemoveTrade.f_93624_ = false;
            }
        } else {
            this.buttonAddTrade.f_93624_ = false;
            this.buttonRemoveTrade.f_93624_ = false;
        }
        this.buttonToggleBankLink.f_93624_ = canLinkAccount = this.getScreen().hasPermission("bankLink");
        if (canLinkAccount) {
            this.buttonToggleBankLink.setResource(TraderSettingsScreen.GUI_TEXTURE, 10, coreSettings.isBankAccountLinked() ? 200 : 220);
            boolean bl = this.buttonToggleBankLink.f_93623_ = coreSettings.canLinkBankAccount() || coreSettings.isBankAccountLinked();
        }
        if (this.buttonSavePersistentTrader != null) {
            this.buttonSavePersistentTrader.f_93624_ = TradingOffice.isAdminPlayer(this.getPlayer());
        }
    }

    @Override
    public void closeTab() {
    }

    @Override
    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    public IconData getIcon() {
        return IconData.of((ItemLike)ModItems.TRADING_CORE);
    }

    @Override
    public Component getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.settings.name");
    }

    private void SetName(Button button) {
        CoreTraderSettings coreSettings = this.getSetting(CoreTraderSettings.class);
        String customName = coreSettings.getCustomName();
        if (!customName.contentEquals(this.nameInput.m_94155_())) {
            CompoundTag updateInfo = coreSettings.setCustomName(this.getPlayer(), this.nameInput.m_94155_());
            coreSettings.sendToServer(updateInfo);
        }
    }

    private void ResetName(Button button) {
        this.nameInput.m_94144_("");
        this.SetName(button);
    }

    private void ToggleCreative(Button button) {
        CoreTraderSettings coreSettings = this.getScreen().getSetting(CoreTraderSettings.class);
        CompoundTag updateInfo = coreSettings.toggleCreative(this.getPlayer());
        coreSettings.sendToServer(updateInfo);
    }

    private void ToggleBankLink(Button button) {
        CoreTraderSettings coreSettings = this.getSetting(CoreTraderSettings.class);
        CompoundTag updateInfo = coreSettings.toggleBankAccountLink(this.getPlayer());
        coreSettings.sendToServer(updateInfo);
    }

    private void AddTrade(Button button) {
        this.getScreen().getTrader().requestAddOrRemoveTrade(true);
    }

    private void RemoveTrade(Button button) {
        this.getScreen().getTrader().requestAddOrRemoveTrade(false);
    }

    private void SavePersistentTraderData(Button button) {
        try {
            ITrader t = this.getScreen().getTrader();
            if (t instanceof UniversalTraderData) {
                UniversalTraderData trader = (UniversalTraderData)t;
                JsonObject result = trader.saveToJson(new JsonObject());
                String resultString = FileUtil.GSON.toJson((JsonElement)result);
                LightmansCurrency.LogInfo("Copied persistent trader json to clipboard.\n" + resultString);
                this.getScreen().getMinecraft().f_91068_.m_90911_(resultString);
                TranslatableComponent message = new TranslatableComponent("lightmanscurrency.chat.persistenttrader");
                message.m_6270_(message.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, resultString)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("tooltip.lightmanscurrency.persistenttrader.copyagain", new Object[]{trader.getName()}))));
                this.getScreen().getMinecraft().f_91074_.m_5661_((Component)message, false);
            }
        }
        catch (Throwable e) {
            LightmansCurrency.LogError("Error saving trader to Json.", e);
        }
    }
}

