/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class ScrollBarWidget
extends AbstractWidget {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/scroll.png");
    public static final int WIDTH = 8;
    public static final int KNOB_HEIGHT = 29;
    public static final int SMALL_KNOB_HEIGHT = 9;
    private final IScrollable scrollable;
    public boolean smallKnob = false;

    private int getKnobHeight() {
        return this.smallKnob ? 9 : 29;
    }

    public ScrollBarWidget(int x, int y, int height, IScrollable scrollable) {
        super(x, y, 8, height, (Component)new TextComponent(""));
        this.scrollable = scrollable;
    }

    public boolean visible() {
        return this.f_93624_ && this.scrollable.getMaxScroll() > this.scrollable.getMinScroll();
    }

    public void m_6303_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        int yPart;
        if (!this.visible()) {
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93228_(pose, this.f_93620_, this.f_93621_, 0, 0, 8, 8);
        for (int yOffset = 8; yOffset < this.f_93619_ - 8; yOffset += yPart) {
            yPart = Math.min(this.f_93619_ - 8 - yOffset, 240);
            this.m_93228_(pose, this.f_93620_, this.f_93621_ + yOffset, 0, 8, 8, yPart);
        }
        this.m_93228_(pose, this.f_93620_, this.f_93621_ + this.f_93619_ - 8, 0, 248, 8, 8);
        this.m_93228_(pose, this.f_93620_, this.f_93621_ + this.getNaturalKnobPosition(), this.smallKnob ? 16 : 8, 0, 8, this.getKnobHeight());
    }

    private int getNaturalKnobPosition() {
        int notches = this.scrollable.getMaxScroll() - this.scrollable.getMinScroll();
        if (notches <= 0) {
            return 0;
        }
        double spacing = (double)(this.f_93619_ - this.getKnobHeight()) / (double)notches;
        int scroll = this.scrollable.currentScroll() - this.scrollable.getMinScroll();
        return (int)Math.round((double)scroll * spacing);
    }

    public void m_142291_(NarrationElementOutput narrator) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return false;
    }

    public static interface IScrollable {
        public int currentScroll();

        public void setScroll(int var1);

        default public int getMinScroll() {
            return 0;
        }

        public int getMaxScroll();
    }
}

