/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class TeamButton
extends Button {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/teambutton.png");
    public static final int HEIGHT = 20;
    public static final int TEXT_COLOR = 0xFFFFFF;
    private final Font font;
    private final Size size;
    private final Supplier<Team> teamSource;
    private final Supplier<Boolean> selectedSource;

    public Team getTeam() {
        return (Team)this.teamSource.get();
    }

    public TeamButton(int x, int y, Size size, Button.OnPress press, Font font, @Nonnull Supplier<Team> teamSource, @Nonnull Supplier<Boolean> selectedSource) {
        super(x, y, size.width, 20, (Component)new TextComponent(""), press);
        this.font = font;
        this.size = size;
        this.teamSource = teamSource;
        this.selectedSource = selectedSource;
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        if (!this.f_93624_ || this.getTeam() == null) {
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93228_(pose, this.f_93620_, this.f_93621_, 0, ((Boolean)this.selectedSource.get() != false ? 20 : 0) + this.size.guiPos, this.size.width, 20);
        this.font.m_92883_(pose, this.fitString(this.getTeam().getName()), (float)(this.f_93620_ + 2), (float)(this.f_93621_ + 2), 0xFFFFFF);
        this.font.m_92883_(pose, this.fitString(new TranslatableComponent("gui.button.lightmanscurrency.team.owner", new Object[]{this.getTeam().getOwner().lastKnownName()}).getString()), (float)(this.f_93620_ + 2), (float)(this.f_93621_ + 10), 0xFFFFFF);
    }

    private String fitString(String string) {
        if (this.font.m_92895_(string) <= this.f_93618_ - 4) {
            return string;
        }
        while (this.font.m_92895_(string + "...") > this.f_93618_ - 4 && string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string + "...";
    }

    public static enum Size {
        WIDE(180, 0),
        NORMAL(156, 1),
        NARROW(90, 2);

        public final int width;
        public final int guiPos;

        private Size(int width, int guiPos) {
            this.width = width;
            this.guiPos = guiPos * 20 * 2;
        }
    }
}

