/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.lockableslot;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.gui.widget.lockableslot.LockableSlotButton;
import io.github.lightman314.lightmanscurrency.menus.slots.LockableSlot;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.misc.MessageLockableSlotInteraction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class LockableSlotInterface {
    List<Pair<Integer, LockableSlotButton>> slotButtons = new ArrayList<Pair<Integer, LockableSlotButton>>();
    public static final String DEFAULT_KEY = "LockableSlots";
    private final AbstractContainerMenu menu;
    private final ILockableSlotInteractableMenu interactableMenu;
    private final String messageKey;

    public LockableSlotInterface(AbstractContainerScreen<?> screen, ILockableSlotInteractableMenu interactableMenu, Consumer<LockableSlotButton> addButton) {
        this(screen, interactableMenu, DEFAULT_KEY, addButton);
    }

    public LockableSlotInterface(AbstractContainerScreen<?> screen, ILockableSlotInteractableMenu interactableMenu, String messageKey, Consumer<LockableSlotButton> addButton) {
        this.messageKey = messageKey;
        this.menu = screen.m_6262_();
        this.interactableMenu = interactableMenu;
        for (Slot slot : screen.m_6262_().f_38839_) {
            if (!(slot instanceof LockableSlot)) continue;
            LockableSlot s = (LockableSlot)slot;
            int slotIndex = s.m_150661_();
            LockableSlotButton button = new LockableSlotButton(screen, s, this::OnPress);
            addButton.accept(button);
            this.slotButtons.add((Pair<Integer, LockableSlotButton>)Pair.of((Object)slotIndex, (Object)((Object)button)));
        }
    }

    public void renderTooltips(Screen screen, PoseStack pose, int mouseX, int mouseY) {
        for (Pair<Integer, LockableSlotButton> buttonPair : this.slotButtons) {
            if (!((LockableSlotButton)((Object)buttonPair.getSecond())).m_5953_(mouseX, mouseY)) continue;
            ((LockableSlotButton)((Object)buttonPair.getSecond())).renderTooltip(screen, pose, mouseX, mouseY);
        }
    }

    private void OnPress(Button button) {
        if (button instanceof LockableSlotButton) {
            int containerIndex = this.getSlotIndex((LockableSlotButton)button);
            if (containerIndex < 0) {
                return;
            }
            this.interactableMenu.OnLockableSlotInteraction(this.messageKey, containerIndex, this.menu.m_142621_());
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageLockableSlotInteraction(this.messageKey, containerIndex, this.menu.m_142621_()));
        }
    }

    private int getSlotIndex(LockableSlotButton button) {
        for (Pair<Integer, LockableSlotButton> buttonPair : this.slotButtons) {
            if (buttonPair.getSecond() != button) continue;
            return (Integer)buttonPair.getFirst();
        }
        return -1;
    }

    public static interface ILockableSlotInteractableMenu {
        public void OnLockableSlotInteraction(String var1, int var2, ItemStack var3);
    }
}

