/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.discord.listeners;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmansconsole.LightmansDiscordIntegration;
import io.github.lightman314.lightmansconsole.discord.links.AccountManager;
import io.github.lightman314.lightmansconsole.discord.links.LinkedAccount;
import io.github.lightman314.lightmansconsole.discord.listeners.types.SingleChannelListener;
import io.github.lightman314.lightmansconsole.util.MessageUtil;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalItemTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.discord.CurrencyMessages;
import io.github.lightman314.lightmanscurrency.discord.events.DiscordPostTradeEvent;
import io.github.lightman314.lightmanscurrency.discord.events.DiscordTraderSearchEvent;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.events.UniversalTraderEvent;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.priv.PrivateMessageReceivedEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CurrencyListener
extends SingleChannelListener {
    private final Timer timer;
    private static final long PENDING_MESSAGE_TIMER = 300000L;
    private static final long ANNOUCEMENT_DELAY = 60000L;
    Map<String, List<String>> pendingMessages = new HashMap<String, List<String>>();

    public CurrencyListener(Supplier<String> consoleChannel) {
        super(consoleChannel, () -> LightmansDiscordIntegration.PROXY.getJDA());
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new NotifyTraderOwnerTask(this), 0L, 300000L);
    }

    protected void onChannelMessageReceived(MessageReceivedEvent event) {
        this.handleMessage(event.getChannel(), event.getMessage(), event.getAuthor());
    }

    public void onPrivateMessageReceived(PrivateMessageReceivedEvent event) {
        this.handleMessage((MessageChannel)event.getChannel(), event.getMessage(), event.getAuthor());
    }

    private void handleMessage(MessageChannel channel, Message message, User author) {
        String prefix;
        if (author.isBot()) {
            return;
        }
        String input = message.getContentDisplay();
        if (input.startsWith(prefix = (String)Config.SERVER.currencyCommandPrefix.get())) {
            String command = input.substring(prefix.length());
            if (command.startsWith("help")) {
                ArrayList<CallSite> output = new ArrayList<CallSite>();
                output.add((CallSite)((Object)(prefix + "notifications <help|enable|disable> - " + CurrencyMessages.M_HELP_LC_NOTIFICATIONS.get())));
                output.add((CallSite)((Object)(prefix + "search <sales|purchases|barters|all> [searchText] - " + CurrencyMessages.M_HELP_LC_SEARCH1.get())));
                output.add((CallSite)((Object)(prefix + "search <players|shops> [searchText] - " + CurrencyMessages.M_HELP_LC_SEARCH2.get())));
                MessageUtil.sendTextMessage((MessageChannel)channel, output);
            } else if (command.startsWith("notifications ")) {
                String subcommand = command.substring(14);
                if (subcommand.startsWith("help")) {
                    ArrayList<String> output = new ArrayList<String>();
                    output.add(AccountManager.currencyNotificationsEnabled((User)author) ? CurrencyMessages.M_NOTIFICATIONS_ENABLED.get() : CurrencyMessages.M_NOTIFICATIONS_DISABLED.get());
                    output.addAll(Lists.newArrayList((Object[])CurrencyMessages.M_NOTIFICATIONS_HELP.get().split("\n")));
                    MessageUtil.sendTextMessage((MessageChannel)channel, output);
                } else if (subcommand.startsWith("enable")) {
                    if (AccountManager.enableCurrencyNotifications((User)author)) {
                        MessageUtil.sendTextMessage((MessageChannel)channel, (String)CurrencyMessages.M_NOTIFICATIONS_ENABLE_SUCCESS.get());
                    } else {
                        MessageUtil.sendTextMessage((MessageChannel)channel, (String)CurrencyMessages.M_NOTIFICATIONS_ENABLE_FAIL.get());
                    }
                } else if (subcommand.startsWith("disable")) {
                    if (AccountManager.disableCurrencyNotifications((User)author)) {
                        MessageUtil.sendTextMessage((MessageChannel)channel, (String)CurrencyMessages.M_NOTIFICATIONS_DISABLE_SUCCESS.get());
                    } else {
                        MessageUtil.sendTextMessage((MessageChannel)channel, (String)CurrencyMessages.M_NOTIFICATIONS_DISABLE_FAIL.get());
                    }
                }
            } else if (command.startsWith("search ")) {
                String subcommand = command.substring(7);
                AtomicReference<String> searchText = new AtomicReference<String>("");
                AtomicBoolean findSales = new AtomicBoolean(false);
                AtomicBoolean findPurchases = new AtomicBoolean(false);
                AtomicBoolean findBarters = new AtomicBoolean(false);
                AtomicBoolean findOwners = new AtomicBoolean(false);
                AtomicBoolean findTraders = new AtomicBoolean(false);
                if (subcommand.startsWith("sales")) {
                    findSales.set(true);
                    if (subcommand.length() > 6) {
                        searchText.set(subcommand.substring(6).toLowerCase());
                    }
                } else if (subcommand.startsWith("purchases")) {
                    findPurchases.set(true);
                    if (subcommand.length() > 10) {
                        searchText.set(subcommand.substring(10).toLowerCase());
                    }
                } else if (subcommand.startsWith("barters")) {
                    findBarters.set(true);
                    if (subcommand.length() > 10) {
                        searchText.set(subcommand.substring(10).toLowerCase());
                    }
                } else if (subcommand.startsWith("players")) {
                    findOwners.set(true);
                    if (subcommand.length() > 8) {
                        searchText.set(subcommand.substring(8).toLowerCase());
                    }
                } else if (subcommand.startsWith("shops")) {
                    findTraders.set(true);
                    if (subcommand.length() > 6) {
                        searchText.set(subcommand.substring(6).toLowerCase());
                    }
                } else if (subcommand.startsWith("all")) {
                    findSales.set(true);
                    findPurchases.set(true);
                    findBarters.set(true);
                    if (subcommand.length() > 4) {
                        searchText.set(subcommand.substring(4).toLowerCase());
                    }
                }
                ArrayList output = new ArrayList();
                TradingOffice.getTraders().forEach(trader -> {
                    try {
                        boolean listTrader;
                        boolean bl = listTrader = findOwners.get() && (((String)searchText.get()).isEmpty() || trader.getCoreSettings().getOwnerName().toLowerCase().contains((CharSequence)searchText.get())) || findTraders.get() && (((String)searchText.get()).isEmpty() || trader.getName().getString().toLowerCase().contains((CharSequence)searchText.get()));
                        if (trader instanceof UniversalItemTraderData) {
                            UniversalItemTraderData itemTrader = (UniversalItemTraderData)trader;
                            if (listTrader) {
                                boolean firstTrade = true;
                                for (int i = 0; i < itemTrader.getTradeCount(); ++i) {
                                    String priceText;
                                    ItemTradeData trade = itemTrader.getTrade(i);
                                    if (!trade.isValid()) continue;
                                    if (firstTrade) {
                                        output.add("--" + itemTrader.getCoreSettings().getOwnerName() + "'s **" + itemTrader.getName().getString() + "**--");
                                        firstTrade = false;
                                    }
                                    if (trade.isSale()) {
                                        priceText = trade.getCost().getString();
                                        output.add("Selling " + CurrencyListener.getItemNamesAndCount(trade.getSellItem(0), trade.getCustomName(0), trade.getSellItem(1), trade.getCustomName(1)) + " for " + priceText);
                                        continue;
                                    }
                                    if (trade.isPurchase()) {
                                        priceText = trade.getCost().getString();
                                        output.add("Purchasing " + CurrencyListener.getItemNamesAndCount(trade.getSellItem(0), "", trade.getSellItem(1), "") + " for " + priceText);
                                        continue;
                                    }
                                    if (!trade.isBarter()) continue;
                                    output.add("Bartering " + CurrencyListener.getItemNamesAndCount(trade.getBarterItem(0), "", trade.getBarterItem(1), "") + " for " + CurrencyListener.getItemNamesAndCount(trade.getSellItem(0), trade.getCustomName(0), trade.getSellItem(1), trade.getCustomName(1)));
                                }
                            } else {
                                for (int i = 0; i < itemTrader.getTradeCount(); ++i) {
                                    String priceText;
                                    String itemName2;
                                    String itemName1;
                                    ItemTradeData trade = itemTrader.getTrade(i);
                                    if (!trade.isValid()) continue;
                                    if (trade.isSale() && findSales.get()) {
                                        itemName1 = CurrencyListener.getItemName(trade.getSellItem(0), trade.getCustomName(0));
                                        itemName2 = CurrencyListener.getItemName(trade.getSellItem(1), trade.getCustomName(0));
                                        if (!((String)searchText.get()).isEmpty() && !itemName1.toLowerCase().contains((CharSequence)searchText.get()) && !itemName2.toLowerCase().contains((CharSequence)searchText.get())) continue;
                                        priceText = trade.getCost().getString();
                                        output.add(itemTrader.getCoreSettings().getOwnerName() + " is selling " + CurrencyListener.getItemNamesAndCount(trade.getSellItem(0), trade.getCustomName(0), trade.getSellItem(1), trade.getCustomName(1)) + " at " + itemTrader.getName().getString() + " for " + priceText);
                                        continue;
                                    }
                                    if (trade.isPurchase() && findPurchases.get()) {
                                        itemName1 = CurrencyListener.getItemName(trade.getSellItem(0), "");
                                        itemName2 = CurrencyListener.getItemName(trade.getSellItem(1), "");
                                        if (!((String)searchText.get()).isEmpty() && !itemName1.toLowerCase().contains((CharSequence)searchText.get()) && !itemName2.toLowerCase().contains((CharSequence)searchText.get())) continue;
                                        priceText = trade.getCost().getString();
                                        output.add(itemTrader.getCoreSettings().getOwnerName() + " is buying " + CurrencyListener.getItemNamesAndCount(trade.getSellItem(0), "", trade.getSellItem(1), "") + " at " + itemTrader.getName().getString() + " for " + priceText);
                                        continue;
                                    }
                                    if (!trade.isBarter() || !findBarters.get()) continue;
                                    itemName1 = CurrencyListener.getItemName(trade.getSellItem(0), trade.getCustomName(0));
                                    itemName2 = CurrencyListener.getItemName(trade.getSellItem(1), trade.getCustomName(1));
                                    String itemName3 = CurrencyListener.getItemName(trade.getBarterItem(0), "");
                                    String itemName4 = CurrencyListener.getItemName(trade.getBarterItem(1), "");
                                    if (!((String)searchText.get()).isEmpty() && !itemName1.toLowerCase().contains((CharSequence)searchText.get()) && !itemName2.toLowerCase().contains((CharSequence)searchText.get()) && !itemName3.toLowerCase().contains((CharSequence)searchText.get()) && !itemName4.toLowerCase().contains((CharSequence)searchText.get())) continue;
                                    output.add(itemTrader.getCoreSettings().getOwnerName() + " is bartering " + CurrencyListener.getItemNamesAndCount(trade.getBarterItem(0), "", trade.getBarterItem(1), "") + " for " + CurrencyListener.getItemNamesAndCount(trade.getSellItem(0), trade.getCustomName(0), trade.getSellItem(1), trade.getCustomName(1)) + " at " + itemTrader.getName().getString());
                                }
                            }
                        } else {
                            MinecraftForge.EVENT_BUS.post((Event)new DiscordTraderSearchEvent((UniversalTraderData)trader, (String)searchText.get(), findSales.get(), findPurchases.get(), findBarters.get(), findOwners.get(), findTraders.get(), output));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                if (output.size() > 0) {
                    MessageUtil.sendTextMessage((MessageChannel)channel, output);
                } else {
                    MessageUtil.sendTextMessage((MessageChannel)channel, (String)CurrencyMessages.M_SEARCH_NORESULTS.get());
                }
            }
        }
    }

    private static String getItemName(ItemStack item, String customName) {
        if (item.m_41619_()) {
            return "";
        }
        StringBuffer itemName = new StringBuffer();
        if (customName.isEmpty()) {
            itemName.append(item.m_41611_().getString());
        } else {
            itemName.append("*").append(customName).append("*");
        }
        AtomicBoolean firstEnchantment = new AtomicBoolean(true);
        EnchantmentHelper.m_44831_((ItemStack)item).forEach((enchantment, level) -> {
            if (firstEnchantment.get()) {
                itemName.append(" [").append(enchantment.m_44700_(level.intValue()).getString());
                firstEnchantment.set(false);
            } else {
                itemName.append(", ").append(enchantment.m_44700_(level.intValue()).getString());
            }
        });
        if (!firstEnchantment.get()) {
            itemName.append("]");
        }
        return itemName.toString();
    }

    private static String getItemNamesAndCount(ItemStack item1, String customName1, ItemStack item2, String customName2) {
        if (item1.m_41619_() && !item2.m_41619_()) {
            return item2.m_41613_() + "x " + CurrencyListener.getItemName(item2, customName2);
        }
        if (item2.m_41619_() && !item1.m_41619_()) {
            return item1.m_41613_() + "x " + CurrencyListener.getItemName(item1, customName1);
        }
        return item1.m_41613_() + "x " + CurrencyListener.getItemName(item1, customName1) + " and " + item2.m_41613_() + "x " + CurrencyListener.getItemName(item2, customName2);
    }

    @SubscribeEvent
    public void onTradeCarriedOut(TradeEvent.PostTradeEvent event) {
        try {
            User linkedUser;
            LinkedAccount account;
            PlayerReference recipient = event.getTrader().getCoreSettings().getOwner();
            if (event.getTrader().getCoreSettings().getTeam() != null) {
                recipient = event.getTrader().getCoreSettings().getTeam().getOwner();
            }
            if ((account = AccountManager.getLinkedAccountFromPlayerID((UUID)recipient.id)) != null && AccountManager.currencyNotificationsEnabled((User)(linkedUser = this.getJDA().getUserById(account.discordID)))) {
                if (event.getTrade() instanceof ItemTradeData) {
                    ItemTradeData itemTrade = (ItemTradeData)event.getTrade();
                    StringBuffer message2 = new StringBuffer();
                    message2.append(event.getPlayerReference().lastKnownName());
                    switch (itemTrade.getTradeType()) {
                        case SALE: {
                            message2.append(" bought ");
                            break;
                        }
                        case PURCHASE: {
                            message2.append(" sold ");
                            break;
                        }
                        case BARTER: {
                            message2.append("bartered ");
                            break;
                        }
                        default: {
                            message2.append(" ??? ");
                        }
                    }
                    if (itemTrade.isBarter()) {
                        message2.append(CurrencyListener.getItemNamesAndCount(itemTrade.getBarterItem(0), "", itemTrade.getBarterItem(1), "")).append(" for ");
                        message2.append(CurrencyListener.getItemNamesAndCount(itemTrade.getSellItem(0), itemTrade.getCustomName(0), itemTrade.getSellItem(1), itemTrade.getCustomName(1)));
                    } else {
                        if (itemTrade.isSale()) {
                            message2.append(CurrencyListener.getItemNamesAndCount(itemTrade.getSellItem(0), itemTrade.getCustomName(0), itemTrade.getSellItem(1), itemTrade.getCustomName(1)));
                        } else {
                            message2.append(CurrencyListener.getItemNamesAndCount(itemTrade.getSellItem(0), "", itemTrade.getSellItem(1), ""));
                        }
                        message2.append(" for ");
                        if (event.getPricePaid().isFree() || event.getPricePaid().getRawValue() <= 0L) {
                            message2.append("free");
                        } else {
                            message2.append(event.getPricePaid().getString());
                        }
                    }
                    message2.append(" from your ").append(event.getTrader().getName().getString());
                    this.addPendingMessage(linkedUser, message2.toString());
                    if (event.getTrader() instanceof IItemTrader && !event.getTrader().isCreative() && itemTrade.stockCount((IItemTrader)event.getTrader()) < 1) {
                        this.addPendingMessage(linkedUser, CurrencyMessages.M_NOTIFICATION_OUTOFSTOCK.get());
                    }
                } else {
                    MinecraftForge.EVENT_BUS.post((Event)new DiscordPostTradeEvent(event, message -> this.addPendingMessage(linkedUser, (String)message)));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addPendingMessage(User user, String message) {
        String userId = user.getId();
        ArrayList pendingMessages = this.pendingMessages.containsKey(userId) ? this.pendingMessages.get(userId) : Lists.newArrayList();
        pendingMessages.add(message);
        this.pendingMessages.put(userId, pendingMessages);
    }

    public void addPendingMessage(User user, List<String> messages) {
        String userId = user.getId();
        ArrayList pendingMessages = this.pendingMessages.containsKey(userId) ? this.pendingMessages.get(userId) : Lists.newArrayList();
        messages.forEach(message -> pendingMessages.add(message));
        this.pendingMessages.put(userId, pendingMessages);
    }

    public void sendPendingMessages() {
        this.pendingMessages.forEach((userId, messages) -> {
            try {
                User user = this.getJDA().getUserById(userId);
                if (user != null) {
                    MessageUtil.sendPrivateMessage((User)user, (List)messages);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.pendingMessages.clear();
    }

    @SubscribeEvent
    public void onUniversalTraderRegistered(UniversalTraderEvent.UniversalTradeCreateEvent event) {
        new Timer().schedule((TimerTask)new AnnouncementTask(this, event), 60000L);
    }

    @SubscribeEvent
    public void onServerStop(ServerStoppingEvent event) {
        this.timer.cancel();
        this.sendPendingMessages();
    }

    private static class NotifyTraderOwnerTask
    extends TimerTask {
        private final CurrencyListener cl;

        public NotifyTraderOwnerTask(CurrencyListener cl) {
            this.cl = cl;
        }

        @Override
        public void run() {
            this.cl.sendPendingMessages();
        }
    }

    private static class AnnouncementTask
    extends TimerTask {
        private final CurrencyListener cl;
        private final UniversalTraderEvent.UniversalTradeCreateEvent event;

        public AnnouncementTask(CurrencyListener cl, UniversalTraderEvent.UniversalTradeCreateEvent event) {
            this.cl = cl;
            this.event = event;
        }

        @Override
        public void run() {
            try {
                if (this.event.getData() == null) {
                    return;
                }
                if (this.event.getData().getCoreSettings().hasCustomName()) {
                    this.cl.sendTextMessage(CurrencyMessages.M_NEWTRADER_NAMED.format(new Object[]{this.event.getData().getCoreSettings().getOwnerName(), this.event.getData().getCoreSettings().getCustomName()}));
                } else {
                    this.cl.sendTextMessage(CurrencyMessages.M_NEWTRADER.format(new Object[]{this.event.getData().getCoreSettings().getOwnerName()}));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

