/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageBankTransferResponse;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageBankTransferPlayer {
    String playerName;
    CoinValue amount;

    public MessageBankTransferPlayer(String playerName, CoinValue amount) {
        this.playerName = playerName;
        this.amount = amount;
    }

    public static void encode(MessageBankTransferPlayer message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.playerName);
        buffer.m_130079_(message.amount.writeToNBT(new CompoundTag(), "CoinValue"));
    }

    public static MessageBankTransferPlayer decode(FriendlyByteBuf buffer) {
        return new MessageBankTransferPlayer(buffer.m_130277_(), new CoinValue(buffer.m_130261_()));
    }

    public static void handle(MessageBankTransferPlayer message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            BankAccount.AccountReference destination;
            BankAccount.IBankAccountTransferMenu menu;
            Component response;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && player.f_36096_ instanceof BankAccount.IBankAccountTransferMenu && (response = BankAccount.TransferCoins(menu = (BankAccount.IBankAccountTransferMenu)player.f_36096_, message.amount, destination = BankAccount.GenerateReference(false, PlayerReference.of(message.playerName)))) != null) {
                LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(player), (Object)new MessageBankTransferResponse(response));
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

