/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.teams;

import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageEditTeam {
    UUID teamID;
    String playerName;
    String category;

    public MessageEditTeam(UUID teamID, String playerName, String category) {
        this.teamID = teamID;
        this.playerName = playerName;
        this.category = category;
    }

    public static void encode(MessageEditTeam message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.teamID);
        buffer.m_130072_(message.playerName, 16);
        buffer.m_130070_(message.category);
    }

    public static MessageEditTeam decode(FriendlyByteBuf buffer) {
        return new MessageEditTeam(buffer.m_130259_(), buffer.m_130136_(16), buffer.m_130277_());
    }

    public static void handle(MessageEditTeam message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            Team team = TradingOffice.getTeam(message.teamID);
            if (team != null) {
                team.changeAny((Player)((NetworkEvent.Context)supplier.get()).getSender(), message.playerName, message.category);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

