/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.walletslot;

import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SPacketSyncWallet {
    int entityID;
    ItemStack walletItem;

    public SPacketSyncWallet(int entityID, ItemStack wallet) {
        this.entityID = entityID;
        this.walletItem = wallet;
    }

    public static void encode(SPacketSyncWallet message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityID);
        buffer.writeItemStack(message.walletItem, false);
    }

    public static SPacketSyncWallet decode(FriendlyByteBuf buffer) {
        return new SPacketSyncWallet(buffer.readInt(), buffer.m_130267_());
    }

    public static void handle(SPacketSyncWallet message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            Entity entity;
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft != null && (entity = minecraft.f_91073_.m_6815_(message.entityID)) instanceof LivingEntity) {
                WalletCapability.getWalletHandler((Entity)((LivingEntity)entity)).ifPresent(walletHandler -> walletHandler.setWallet(message.walletItem));
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

