/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.interfacing;

import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.trader.ITradeSource;
import io.github.lightman314.lightmanscurrency.trader.interfacing.UniversalTraderReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeData;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class UniversalTradeReference<T extends TradeData>
extends UniversalTraderReference {
    private Function<CompoundTag, T> tradeDeserializer;
    private int tradeIndex = -1;
    private T tradeData = null;
    private Class<?> tradeClass = null;

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public boolean hasTrade() {
        return this.tradeIndex >= 0 && this.tradeData != null;
    }

    public T getLocalTrade() {
        return this.tradeData;
    }

    public void setTrade(int tradeIndex) {
        this.tradeIndex = tradeIndex;
        T trade = this.getTrueTrade();
        if (trade != null) {
            this.tradeData = trade;
            this.tradeClass = trade.getClass();
        } else {
            this.tradeIndex = -1;
        }
    }

    public void refreshTrade() {
        if (!this.hasTrade()) {
            return;
        }
        T newTrade = this.getTrueTrade();
        if (newTrade != null) {
            this.tradeData = newTrade;
            this.tradeClass = newTrade.getClass();
        }
    }

    public UniversalTradeReference(Supplier<Boolean> clientCheck, Function<CompoundTag, T> tradeDeserializer) {
        super(clientCheck);
        this.tradeDeserializer = tradeDeserializer;
    }

    public T getTrueTrade() {
        ITradeSource tradeSource;
        Object trade;
        if (this.tradeIndex < 0) {
            return null;
        }
        UniversalTraderData trader = this.getTrader();
        if (trader instanceof ITradeSource && (trade = (tradeSource = (ITradeSource)((Object)trader)).getTrade(this.tradeIndex)) != null && trade.getClass() == this.tradeClass) {
            return (T)((TradeData)trade);
        }
        return null;
    }

    @Override
    public CompoundTag save() {
        CompoundTag compound = super.save();
        if (this.tradeData != null && this.tradeIndex >= 0) {
            compound.m_128405_("tradeIndex", this.tradeIndex);
            compound.m_128365_("trade", (Tag)((TradeData)this.tradeData).getAsNBT());
        }
        return compound;
    }

    @Override
    public void load(CompoundTag compound) {
        super.load(compound);
        if (compound.m_128403_("tradeIndex")) {
            this.tradeIndex = compound.m_128451_("tradeIndex");
        }
        if (compound.m_128425_("trade", 10)) {
            this.tradeData = (TradeData)this.tradeDeserializer.apply(compound.m_128469_("trade"));
            if (this.tradeData != null) {
                this.tradeClass = this.tradeData.getClass();
            }
        }
    }
}

