/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.items.TicketItem;
import io.github.lightman314.lightmanscurrency.menus.slots.TicketSlot;
import io.github.lightman314.lightmanscurrency.trader.common.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TicketKioskRestriction
extends ItemTradeRestriction {
    public static TicketKioskRestriction INSTANCE = new TicketKioskRestriction();

    private TicketKioskRestriction() {
    }

    @Override
    public ItemStack modifySellItem(ItemStack sellItem, String customName, ItemTradeData trade) {
        if (sellItem.m_41720_() instanceof TicketItem && !customName.isBlank()) {
            sellItem.m_41714_((Component)new TextComponent(customName));
        }
        return sellItem;
    }

    @Override
    public boolean allowSellItem(ItemStack itemStack) {
        if (TicketItem.isMasterTicket(itemStack)) {
            return true;
        }
        return InventoryUtil.ItemHasTag(itemStack, TicketItem.TICKET_MATERIAL_TAG) && itemStack.m_41720_() != ModItems.TICKET;
    }

    @Override
    public ItemStack filterSellItem(ItemStack itemStack) {
        if (TicketItem.isMasterTicket(itemStack)) {
            return TicketItem.CreateTicket(TicketItem.GetTicketID(itemStack), 1);
        }
        if (InventoryUtil.ItemHasTag(itemStack, TicketItem.TICKET_MATERIAL_TAG) && itemStack.m_41720_() != ModItems.TICKET) {
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean allowItemSelectItem(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        return InventoryUtil.ItemHasTag(itemStack, TicketItem.TICKET_MATERIAL_TAG) && item != ModItems.TICKET && item != ModItems.TICKET_MASTER;
    }

    @Override
    public boolean allowExtraItemInStorage(ItemStack itemStack) {
        return InventoryUtil.ItemHasTag(itemStack, TicketItem.TICKET_MATERIAL_TAG);
    }

    @Override
    public int getSaleStock(ItemStack sellItem, TraderItemStorage traderStorage) {
        if (sellItem.m_41720_() == ModItems.TICKET) {
            return traderStorage.getItemTagCount(TicketItem.TICKET_MATERIAL_TAG, ModItems.TICKET_MASTER) / sellItem.m_41613_();
        }
        return super.getSaleStock(sellItem, traderStorage);
    }

    @Override
    public void removeItemsFromStorage(ItemStack sellItem, TraderItemStorage traderStorage) {
        if (sellItem.m_41720_() == ModItems.TICKET) {
            int amountToRemove = sellItem.m_41613_();
            if ((amountToRemove -= traderStorage.removeItem(sellItem).m_41613_()) > 0) {
                traderStorage.removeItemTagCount(TicketItem.TICKET_MATERIAL_TAG, amountToRemove, ModItems.TICKET_MASTER);
            }
        } else {
            super.removeItemsFromStorage(sellItem, traderStorage);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Pair<ResourceLocation, ResourceLocation> getEmptySlotBG() {
        return Pair.of((Object)InventoryMenu.f_39692_, (Object)TicketSlot.EMPTY_TICKET_SLOT);
    }
}

