/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerBlacklist
extends TradeRule {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "blacklist");
    List<PlayerReference> bannedPlayers = new ArrayList<PlayerReference>();

    public PlayerBlacklist() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.isBlacklisted(event.getPlayerReference())) {
            event.denyTrade((Component)new TranslatableComponent("traderule.lightmanscurrency.blacklist.denial"));
        }
    }

    public boolean isBlacklisted(PlayerReference player) {
        for (int i = 0; i < this.bannedPlayers.size(); ++i) {
            if (!this.bannedPlayers.get(i).is(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompoundTag write(CompoundTag compound) {
        ListTag playerNameList = new ListTag();
        for (int i = 0; i < this.bannedPlayers.size(); ++i) {
            playerNameList.add((Object)this.bannedPlayers.get(i).save());
        }
        compound.m_128365_("BannedPlayers", (Tag)playerNameList);
        return compound;
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        JsonArray blacklist = new JsonArray();
        for (int i = 0; i < this.bannedPlayers.size(); ++i) {
            blacklist.add((JsonElement)this.bannedPlayers.get(i).saveAsJson());
        }
        json.add("BannedPlayers", (JsonElement)blacklist);
        return json;
    }

    @Override
    public void readNBT(CompoundTag compound) {
        int i;
        if (compound.m_128425_("BannedPlayers", 9)) {
            this.bannedPlayers.clear();
            ListTag playerList = compound.m_128437_("BannedPlayers", 10);
            for (i = 0; i < playerList.size(); ++i) {
                PlayerReference reference = PlayerReference.load(playerList.m_128728_(i));
                if (reference == null) continue;
                this.bannedPlayers.add(reference);
            }
        }
        if (compound.m_128425_("BannedPlayersNames", 9)) {
            this.bannedPlayers.clear();
            ListTag playerNameList = compound.m_128437_("BannedPlayersNames", 10);
            for (i = 0; i < playerNameList.size(); ++i) {
                PlayerReference reference;
                CompoundTag thisCompound = playerNameList.m_128728_(i);
                if (!thisCompound.m_128425_("name", 8) || (reference = PlayerReference.of(thisCompound.m_128461_("name"))) == null || this.isBlacklisted(reference)) continue;
                this.bannedPlayers.add(reference);
            }
        }
    }

    @Override
    public void handleUpdateMessage(CompoundTag updateInfo) {
        boolean add = updateInfo.m_128471_("Add");
        String name = updateInfo.m_128461_("Name");
        PlayerReference player = PlayerReference.of(name);
        if (player == null) {
            return;
        }
        if (add && !this.isBlacklisted(player)) {
            this.bannedPlayers.add(player);
        } else if (!add && this.isBlacklisted(player)) {
            PlayerReference.removeFromList(this.bannedPlayers, name);
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("BannedPlayers")) {
            this.bannedPlayers.clear();
            JsonArray blacklist = json.get("BannedPlayers").getAsJsonArray();
            for (int i = 0; i < blacklist.size(); ++i) {
                PlayerReference reference = PlayerReference.load((JsonElement)blacklist.get(i).getAsJsonObject());
                if (reference == null || this.isBlacklisted(reference)) continue;
                this.bannedPlayers.add(reference);
            }
        }
    }

    @Override
    public CompoundTag savePersistentData() {
        return null;
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_BLACKLIST;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        EditBox nameInput;
        Button buttonAddPlayer;
        Button buttonRemovePlayer;
        ScrollTextDisplay playerDisplay;

        protected final PlayerBlacklist getBlacklistRule() {
            if (this.getRuleRaw() instanceof PlayerBlacklist) {
                return (PlayerBlacklist)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            Font font = this.screen.getFont();
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 9;
            Objects.requireNonNull(this.screen);
            this.nameInput = this.addCustomRenderable(new EditBox(font, n, n2, 176 - 20, 20, (Component)new TextComponent("")));
            this.buttonAddPlayer = this.addCustomRenderable(new Button(this.screen.guiLeft() + 10, this.screen.guiTop() + 30, 78, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.blacklist.add"), this::PressBlacklistButton));
            int n3 = this.screen.guiLeft();
            Objects.requireNonNull(this.screen);
            this.buttonRemovePlayer = this.addCustomRenderable(new Button(n3 + 176 - 88, this.screen.guiTop() + 30, 78, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.blacklist.remove"), this::PressForgiveButton));
            int n4 = this.screen.guiLeft() + 7;
            int n5 = this.screen.guiTop() + 55;
            Objects.requireNonNull(this.screen);
            this.playerDisplay = this.addCustomRenderable(new ScrollTextDisplay(n4, n5, 176 - 14, 114, this.screen.getFont(), (Supplier<List<? extends Component>>)((Supplier)this::getBlacklistedPlayers)));
            this.playerDisplay.setColumnCount(2);
        }

        private List<Component> getBlacklistedPlayers() {
            ArrayList playerList = Lists.newArrayList();
            if (this.getBlacklistRule() == null) {
                return playerList;
            }
            for (PlayerReference player : this.getBlacklistRule().bannedPlayers) {
                playerList.add(new TextComponent(player.lastKnownName()));
            }
            return playerList;
        }

        @Override
        public void renderTab(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        }

        @Override
        public void onTabClose() {
            this.removeCustomWidget(this.nameInput);
            this.removeCustomWidget(this.buttonAddPlayer);
            this.removeCustomWidget(this.buttonRemovePlayer);
            this.removeCustomWidget(this.playerDisplay);
        }

        void PressBlacklistButton(Button button) {
            String name = this.nameInput.m_94155_();
            if (name != "") {
                this.nameInput.m_94144_("");
                PlayerReference reference = PlayerReference.of(name);
                if (reference != null && !this.getBlacklistRule().isBlacklisted(reference)) {
                    this.getBlacklistRule().bannedPlayers.add(reference);
                }
                CompoundTag updateInfo = new CompoundTag();
                updateInfo.m_128379_("Add", true);
                updateInfo.m_128359_("Name", name);
                this.screen.updateServer(TYPE, updateInfo);
            }
        }

        void PressForgiveButton(Button button) {
            String name = this.nameInput.m_94155_();
            if (name != "") {
                this.nameInput.m_94144_("");
                PlayerReference reference = PlayerReference.of(name);
                if (this.getBlacklistRule().isBlacklisted(reference)) {
                    boolean notFound = true;
                    for (int i = 0; notFound && i < this.getBlacklistRule().bannedPlayers.size(); ++i) {
                        if (!this.getBlacklistRule().bannedPlayers.get(i).is(reference)) continue;
                        notFound = false;
                        this.getBlacklistRule().bannedPlayers.remove(i);
                    }
                }
                CompoundTag updateInfo = new CompoundTag();
                updateInfo.m_128379_("Add", false);
                updateInfo.m_128359_("Name", name);
                this.screen.updateServer(TYPE, updateInfo);
            }
        }
    }
}

