/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.misc;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import shetiphian.core.common.NBTFile;
import shetiphian.multibeds.MultiBeds;
import shetiphian.multibeds.client.misc.WIPProject;
import shetiphian.multibeds.common.misc.Embroidery;

@OnlyIn(value=Dist.CLIENT)
public class EmbroideryData {
    public static final EmbroideryData INSTANCE = new EmbroideryData();
    private final HashMap<String, Embroidery> personal = new HashMap();
    private final HashMap<String, Embroidery> favorite = new HashMap();
    private final HashMap<String, Embroidery> session = new HashMap();
    private final HashMap<String, Embroidery> webpage = new HashMap();
    private final HashMap<String, WIPProject> projects = new HashMap();
    private boolean needsSaving = false;
    private boolean isLoaded = false;
    private String saveDir = null;

    public static boolean has(String name) {
        return EmbroideryData.INSTANCE.personal.containsKey(name);
    }

    public static void save(String name, Embroidery embroidery) {
        EmbroideryData.INSTANCE.personal.put(name, embroidery);
        EmbroideryData.INSTANCE.needsSaving = true;
    }

    public static void delete(String name) {
        EmbroideryData.INSTANCE.personal.remove(name);
        EmbroideryData.INSTANCE.needsSaving = true;
    }

    public static Set<String> getNames() {
        return EmbroideryData.INSTANCE.personal.keySet();
    }

    public static Embroidery get(String name) {
        return EmbroideryData.INSTANCE.personal.get(name);
    }

    public static void favorite(String name, Embroidery embroidery) {
        EmbroideryData.INSTANCE.favorite.put(name, embroidery);
        EmbroideryData.INSTANCE.needsSaving = true;
    }

    public static void unfavorite(String name) {
        EmbroideryData.INSTANCE.favorite.remove(name);
        EmbroideryData.INSTANCE.needsSaving = true;
    }

    public static Set<String> getFavorites() {
        return EmbroideryData.INSTANCE.favorite.keySet();
    }

    public static Embroidery getFavorite(String name) {
        return EmbroideryData.INSTANCE.favorite.get(name);
    }

    public static void addSessionItem(String name, Embroidery embroidery) {
        EmbroideryData.INSTANCE.session.put(name, embroidery);
    }

    public static Set<String> getSessionItems() {
        return EmbroideryData.INSTANCE.session.keySet();
    }

    public static Embroidery getSessionItem(String name) {
        return EmbroideryData.INSTANCE.session.get(name);
    }

    public static Set<String> getWebItems() {
        return EmbroideryData.INSTANCE.webpage.keySet();
    }

    public static Embroidery getWebItem(String name) {
        return EmbroideryData.INSTANCE.webpage.get(name);
    }

    public static boolean hasProject(String name) {
        return EmbroideryData.INSTANCE.projects.containsKey(name);
    }

    public static void saveProject(String name, WIPProject project) {
        EmbroideryData.INSTANCE.projects.put(name, project);
        EmbroideryData.INSTANCE.needsSaving = true;
    }

    public static void deleteProject(String name) {
        EmbroideryData.INSTANCE.projects.remove(name);
        EmbroideryData.INSTANCE.needsSaving = true;
    }

    public static Set<String> getProjects() {
        return EmbroideryData.INSTANCE.projects.keySet();
    }

    public static WIPProject getProject(String name) {
        return EmbroideryData.INSTANCE.projects.get(name);
    }

    public void saveData() {
        if (!this.isLoaded) {
            MultiBeds.LOGGER.error("Attempted to save Embroidery Data when nothing is loaded");
            return;
        }
        if (this.needsSaving) {
            CompoundTag fileNBT = new CompoundTag();
            for (Map.Entry<String, Embroidery> entry : this.personal.entrySet()) {
                fileNBT.m_128359_(entry.getKey(), entry.getValue().buildShareTag(new String[0]));
            }
            ListTag favoritesNBT = new ListTag();
            for (String string : EmbroideryData.getFavorites()) {
                favoritesNBT.add((Object)StringTag.m_129297_((String)string));
            }
            fileNBT.m_128365_("FavoritesList", (Tag)favoritesNBT);
            fileNBT.m_128365_("ByteArrayImport", (Tag)new CompoundTag());
            NBTFile.write((CompoundTag)fileNBT, (File)this.getSaveFile(false), (Logger)MultiBeds.LOGGER);
            fileNBT = new CompoundTag();
            for (Map.Entry entry : this.projects.entrySet()) {
                fileNBT.m_128365_((String)entry.getKey(), (Tag)((WIPProject)entry.getValue()).writeToNbt());
            }
            NBTFile.write((CompoundTag)fileNBT, (File)this.getSaveFile(true), (Logger)MultiBeds.LOGGER);
            this.needsSaving = false;
        }
    }

    public void loadData() {
        this.loadPersistentData();
        this.loadUrlData();
    }

    private void loadPersistentData() {
        MultiBeds.LOGGER.info("Loading Embroidery Data");
        this.saveDir = FMLPaths.GAMEDIR.get().toString() + File.separator + ".persistent" + File.separator + "multibeds";
        this.personal.clear();
        this.favorite.clear();
        CompoundTag fileNBT = NBTFile.read((File)this.getSaveFile(false), (Logger)MultiBeds.LOGGER);
        ListTag favoritesNBT = null;
        CompoundTag importNBT = null;
        for (Object name : fileNBT.m_128431_()) {
            if (((String)name).equals("FavoritesList") && fileNBT.m_128423_((String)name) instanceof ListTag) {
                favoritesNBT = fileNBT.m_128437_("FavoritesList", 8);
                continue;
            }
            if (((String)name).equals("ByteArrayImport") && fileNBT.m_128423_((String)name) instanceof CompoundTag) {
                importNBT = fileNBT.m_128469_((String)name);
            }
            try {
                Pair<String, Embroidery> data = Embroidery.fromShareTag(fileNBT.m_128461_((String)name));
                if (data == null) continue;
                this.personal.put((String)name, (Embroidery)data.getValue());
            }
            catch (Exception data) {}
        }
        if (favoritesNBT != null) {
            for (int index = 0; index < favoritesNBT.size(); ++index) {
                String entry = favoritesNBT.m_128778_(index);
                String[] name = entry.split(":");
                if (name.length != 2) continue;
                if (name[0].equalsIgnoreCase("inc")) {
                    this.favorite.put(entry, null);
                    continue;
                }
                if (!name[0].equalsIgnoreCase("per") || !this.personal.containsKey(name[1])) continue;
                this.favorite.put(entry, this.personal.get(name[1]));
            }
        }
        if (importNBT != null) {
            for (Object name : importNBT.m_128431_()) {
                try {
                    Embroidery embroidery = Embroidery.fromUncompressed((byte)0, importNBT.m_128463_((String)name));
                    name = "imp:" + (String)name;
                    while (this.session.containsKey(name)) {
                        name = (String)name + "_";
                    }
                    this.session.put((String)name, embroidery);
                }
                catch (Exception exception) {}
            }
        }
        this.projects.clear();
        fileNBT = NBTFile.read((File)this.getSaveFile(true), (Logger)MultiBeds.LOGGER);
        for (Object name : fileNBT.m_128431_()) {
            try {
                this.projects.put((String)name, WIPProject.fromNbtTag(fileNBT.m_128469_((String)name)));
            }
            catch (Exception exception) {}
        }
        this.isLoaded = true;
    }

    private File getSaveFile(boolean projects) {
        File file = new File(this.saveDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(this.saveDir, projects ? "projects.dat" : "embroidery.dat")).exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception error) {
                MultiBeds.LOGGER.error("Could Not Read or Create File: " + file, (Throwable)error);
            }
            NBTFile.write((CompoundTag)new CompoundTag(), (File)file, (Logger)MultiBeds.LOGGER);
        }
        return file;
    }

    private void loadUrlData() {
        this.process("https://gist.githubusercontent.com/Fruzstrated/ee01d31ff5208027f88c0dbc3543b43a/raw");
        this.process("https://gist.githubusercontent.com/ShetiPhian/657d2933fbeed6f49bfe95294a589e5b/raw");
    }

    private void process(String address) {
        Pair<String, Embroidery> data;
        Map json = null;
        try {
            URL url = new URL(address);
            InputStream con = url.openStream();
            data = new Pair<String, Embroidery>(ByteStreams.toByteArray((InputStream)con), StandardCharsets.UTF_8);
            con.close();
            json = (Map)new Gson().fromJson((String)data, Map.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (json != null) {
            for (Map.Entry entry : json.entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                try {
                    data = Embroidery.fromShareTag((String)entry.getValue());
                    if (data == null) continue;
                    this.webpage.put((String)entry.getKey(), (Embroidery)data.getValue());
                }
                catch (Exception exception) {}
            }
            try {
                this.loadSet((Map)json.get("previews"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.processTimed((Map)json.get("timed"), json);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void processTimed(Map<String, Object> timed, Map<String, Object> json) {
        if (timed != null) {
            int month = Calendar.getInstance().get(2) + 1;
            int day = Calendar.getInstance().get(5);
            for (String date : timed.keySet()) {
                boolean inRange;
                block12: {
                    inRange = false;
                    if (date.contains("-")) {
                        String[] range = date.split("-");
                        String[] start_month_day = range[0].split("/");
                        String[] end_month_day = range[1].split("/");
                        try {
                            int start_month = Integer.parseInt(start_month_day[0]);
                            int start_day = Integer.parseInt(start_month_day[1]);
                            int end_month = Integer.parseInt(end_month_day[0]);
                            int end_day = Integer.parseInt(end_month_day[1]);
                            if (start_month > end_month) {
                                inRange = month >= start_month || month <= end_month;
                            } else {
                                boolean bl = inRange = month >= start_month && month <= end_month;
                            }
                            if (!inRange) break block12;
                            if (start_day > end_day) {
                                inRange = day >= start_day || day <= end_day;
                                break block12;
                            }
                            inRange = day >= start_day && day <= end_day;
                        }
                        catch (Exception exception) {}
                    } else {
                        String[] month_day = date.split("/");
                        try {
                            if (month == Integer.parseInt(month_day[0]) && day == Integer.parseInt(month_day[1])) {
                                inRange = true;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (!inRange) continue;
                this.loadSet((Map)json.get(date));
            }
        }
    }

    private void loadSet(Map<String, String> set) {
        for (Map.Entry<String, String> entry : set.entrySet()) {
            try {
                Pair<String, Embroidery> data = Embroidery.fromShareTag(entry.getValue());
                if (data == null) continue;
                this.webpage.put(entry.getKey(), (Embroidery)data.getValue());
            }
            catch (Exception exception) {}
        }
    }
}

